/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.fixed;

import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.fixed.FixedThreadPoolModuleMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFixedThreadPoolModule
implements Module,
FixedThreadPoolModuleMXBean,
ThreadPoolServiceInterface {
    protected final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    protected final JmxAttribute maxThreadCountJmxAttribute = new JmxAttribute("MaxThreadCount");
    private Integer maxThreadCount;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFixedThreadPoolModule.class);
    private final AbstractFixedThreadPoolModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private ThreadFactory threadFactoryDependency;

    public AbstractFixedThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractFixedThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractFixedThreadPoolModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Integer getMaxThreadCount() {
        return this.maxThreadCount;
    }

    @Override
    public void setMaxThreadCount(Integer maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadFactoryServiceInterface.class, this.threadFactory, this.threadFactoryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, this.threadFactoryJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractFixedThreadPoolModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractFixedThreadPoolModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.threadFactoryDependency != other.threadFactoryDependency) {
            return false;
        }
        return !(this.maxThreadCount == null ? other.maxThreadCount != null : !this.maxThreadCount.equals(other.maxThreadCount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFixedThreadPoolModule that = (AbstractFixedThreadPoolModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

