/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.NamingThreadFactoryModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl", revision="2013-04-05", name="threadpool-impl")
public abstract class AbstractNamingThreadFactoryModuleFactory
implements ModuleFactory {
    public static final String NAME = "threadfactory-naming";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        NamingThreadFactoryModule oldModule = null;
        try {
            oldModule = (NamingThreadFactoryModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        NamingThreadFactoryModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setNamePrefix(oldModule.getNamePrefix());
        return module;
    }

    public NamingThreadFactoryModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, NamingThreadFactoryModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new NamingThreadFactoryModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public NamingThreadFactoryModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new NamingThreadFactoryModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public final String getImplementationName() {
        return NAME;
    }

    public NamingThreadFactoryModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<NamingThreadFactoryModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<NamingThreadFactoryModule>();
    }

    static {
        HashSet<Class<ThreadFactoryServiceInterface>> serviceIfcs2 = new HashSet<Class<ThreadFactoryServiceInterface>>();
        serviceIfcs2.add(ThreadFactoryServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

