/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.threadpool.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NamingThreadPoolFactory
implements ThreadFactory,
Closeable {
    private final ThreadGroup group;
    private final String namePrefix;
    private final AtomicLong threadName = new AtomicLong();

    public NamingThreadPoolFactory(String namePrefix) {
        Preconditions.checkNotNull((Object)namePrefix);
        this.group = new ThreadGroup(namePrefix);
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.group, r, String.format("%s-%d", this.group.getName(), this.threadName.incrementAndGet()));
    }

    @Override
    public void close() throws IOException {
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }
}

