/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.threadpool.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.threadpool.ThreadPool;

public class FlexibleThreadPoolWrapper
implements ThreadPool,
Closeable {
    private final ThreadPoolExecutor executor;

    public FlexibleThreadPoolWrapper(int minThreadCount, int maxThreadCount, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this.executor = new ThreadPoolExecutor(minThreadCount, maxThreadCount, keepAlive, timeUnit, new SynchronousQueue<Runnable>(), threadFactory);
        this.executor.prestartAllCoreThreads();
    }

    public ExecutorService getExecutor() {
        return Executors.unconfigurableExecutorService(this.executor);
    }

    public int getMinThreadCount() {
        return this.executor.getCorePoolSize();
    }

    public void setMinThreadCount(int minThreadCount) {
        this.executor.setCorePoolSize(minThreadCount);
    }

    public int getMaxThreadCount() {
        return this.executor.getMaximumPoolSize();
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.executor.setMaximumPoolSize(maxThreadCount);
    }

    public long getKeepAliveMillis() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveMillis(long keepAliveMillis) {
        this.executor.setKeepAliveTime(keepAliveMillis, TimeUnit.MILLISECONDS);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.executor.setThreadFactory(threadFactory);
    }

    public void prestartAllCoreThreads() {
        this.executor.prestartAllCoreThreads();
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }
}

