/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.protocol.framework.AbstractDispatcher;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategyFactory;
import org.opendaylight.protocol.framework.SessionListener;

final class ReconnectPromise<S extends ProtocolSession<?>, L extends SessionListener<?, ?, ?>>
extends DefaultPromise<Void> {
    private final AbstractDispatcher<S, L> dispatcher;
    private final InetSocketAddress address;
    private final ReconnectStrategyFactory strategyFactory;
    private final ReconnectStrategy strategy;
    private final AbstractDispatcher.PipelineInitializer<S> initializer;
    private Future<?> pending;
    private final AtomicBoolean negotiationFinished = new AtomicBoolean(false);
    private final ClosedChannelListener closedChannelListener = new ClosedChannelListener();

    public ReconnectPromise(EventExecutor executor, AbstractDispatcher<S, L> dispatcher, InetSocketAddress address, ReconnectStrategyFactory connectStrategyFactory, ReconnectStrategy reestablishStrategy, AbstractDispatcher.PipelineInitializer<S> initializer) {
        super(executor);
        this.dispatcher = (AbstractDispatcher)Preconditions.checkNotNull(dispatcher);
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.strategyFactory = (ReconnectStrategyFactory)Preconditions.checkNotNull((Object)connectStrategyFactory);
        this.strategy = (ReconnectStrategy)Preconditions.checkNotNull((Object)reestablishStrategy);
        this.initializer = (AbstractDispatcher.PipelineInitializer)Preconditions.checkNotNull(initializer);
    }

    synchronized void connect() {
        this.negotiationFinished.set(false);
        final ReconnectStrategy cs = this.strategyFactory.createReconnectStrategy();
        ReconnectStrategy rs = new ReconnectStrategy(){

            @Override
            public Future<Void> scheduleReconnect(Throwable cause) {
                return cs.scheduleReconnect(cause);
            }

            @Override
            public void reconnectSuccessful() {
                cs.reconnectSuccessful();
            }

            @Override
            public int getConnectTimeout() throws Exception {
                int cst = cs.getConnectTimeout();
                int rst = ReconnectPromise.this.strategy.getConnectTimeout();
                if (cst == 0) {
                    return rst;
                }
                if (rst == 0) {
                    return cst;
                }
                return Math.min(cst, rst);
            }
        };
        Future<S> cf = this.dispatcher.createClient(this.address, rs, new AbstractDispatcher.PipelineInitializer<S>(){

            @Override
            public void initializeChannel(SocketChannel channel, Promise<S> promise) {
                ReconnectPromise.this.addChannelClosedListener(channel.closeFuture());
                ReconnectPromise.this.initializer.initializeChannel(channel, promise);
            }
        });
        ReconnectPromise lock = this;
        this.pending = cf;
        cf.addListener((GenericFutureListener)new FutureListener<S>((Object)lock, cf){
            final /* synthetic */ Object val$lock;
            final /* synthetic */ Future val$cf;
            {
                this.val$lock = object;
                this.val$cf = future;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<S> future) {
                Object object = this.val$lock;
                synchronized (object) {
                    if (!future.isSuccess()) {
                        Future<Void> rf = ReconnectPromise.this.strategy.scheduleReconnect(this.val$cf.cause());
                        if (rf == null) {
                            return;
                        }
                        ReconnectPromise.this.pending = rf;
                        rf.addListener((GenericFutureListener)new FutureListener<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(Future<Void> sf) {
                                Object object = val$lock;
                                synchronized (object) {
                                    if (!ReconnectPromise.this.isCancelled()) {
                                        if (sf.isSuccess()) {
                                            ReconnectPromise.this.connect();
                                        } else {
                                            ReconnectPromise.this.setFailure(sf.cause());
                                        }
                                    }
                                }
                            }
                        });
                    } else {
                        ReconnectPromise.this.strategy.reconnectSuccessful();
                        ReconnectPromise.this.negotiationFinished.set(true);
                    }
                }
            }
        });
    }

    private void addChannelClosedListener(ChannelFuture channelFuture) {
        channelFuture.addListener((GenericFutureListener)this.closedChannelListener);
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.closedChannelListener.close();
        if (super.cancel(mayInterruptIfRunning)) {
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    class ClosedChannelListener
    implements Closeable,
    FutureListener<Void> {
        private final AtomicBoolean stop = new AtomicBoolean(false);

        ClosedChannelListener() {
        }

        public void operationComplete(Future<Void> future) throws Exception {
            if (this.stop.get()) {
                return;
            }
            if (!ReconnectPromise.this.negotiationFinished.get()) {
                return;
            }
            ReconnectPromise.this.connect();
        }

        @Override
        public void close() {
            this.stop.set(true);
        }
    }
}

