/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ReconnectImmediatelyStrategy
implements ReconnectStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectImmediatelyStrategy.class);
    private final EventExecutor executor;
    private final int timeout;

    public ReconnectImmediatelyStrategy(EventExecutor executor, int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0);
        this.executor = (EventExecutor)Preconditions.checkNotNull((Object)executor);
        this.timeout = timeout;
    }

    @Override
    public Future<Void> scheduleReconnect(Throwable cause) {
        LOG.debug("Connection attempt failed", cause);
        return this.executor.newSucceededFuture(null);
    }

    @Override
    public void reconnectSuccessful() {
    }

    @Override
    public int getConnectTimeout() {
        return this.timeout;
    }
}

