/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class ProtocolSessionPromise<S extends ProtocolSession<?>>
extends DefaultPromise<S> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolSessionPromise.class);
    private final ReconnectStrategy strategy;
    private final InetSocketAddress address;
    private final Bootstrap b;
    @GuardedBy(value="this")
    private Future<?> pending;

    ProtocolSessionPromise(EventExecutor executor, InetSocketAddress address, ReconnectStrategy strategy, Bootstrap b) {
        super(executor);
        this.strategy = (ReconnectStrategy)Preconditions.checkNotNull((Object)strategy);
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.b = (Bootstrap)Preconditions.checkNotNull((Object)b);
    }

    synchronized void connect() {
        ProtocolSessionPromise lock = this;
        try {
            int timeout = this.strategy.getConnectTimeout();
            LOG.debug("Promise {} attempting connect for {}ms", (Object)lock, (Object)timeout);
            this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
            this.pending = this.b.connect((SocketAddress)this.address).addListener((GenericFutureListener)new ChannelFutureListener((Object)lock){
                final /* synthetic */ Object val$lock;
                {
                    this.val$lock = object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ChannelFuture cf) throws Exception {
                    Object object = this.val$lock;
                    synchronized (object) {
                        LOG.debug("Promise {} connection resolved", this.val$lock);
                        Preconditions.checkState((boolean)ProtocolSessionPromise.this.pending.equals(cf));
                        if (ProtocolSessionPromise.this.isCancelled()) {
                            if (cf.isSuccess()) {
                                LOG.debug("Closing channel for cancelled promise {}", this.val$lock);
                                cf.channel().close();
                            }
                            return;
                        }
                        if (!cf.isSuccess()) {
                            LOG.warn("Attempt to connect to connect to {} failed", (Object)ProtocolSessionPromise.this.address, (Object)cf.cause());
                            Future<Void> rf = ProtocolSessionPromise.this.strategy.scheduleReconnect(cf.cause());
                            rf.addListener((GenericFutureListener)new FutureListener<Void>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void operationComplete(Future<Void> sf) {
                                    Object object = val$lock;
                                    synchronized (object) {
                                        Preconditions.checkState((boolean)ProtocolSessionPromise.this.pending.equals(sf));
                                        if (!ProtocolSessionPromise.this.isCancelled()) {
                                            if (sf.isSuccess()) {
                                                ProtocolSessionPromise.this.connect();
                                            } else {
                                                ProtocolSessionPromise.this.setFailure(sf.cause());
                                            }
                                        }
                                    }
                                }
                            });
                            ProtocolSessionPromise.this.pending = rf;
                        } else {
                            LOG.debug("Promise {} connection successful", this.val$lock);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.info("Failed to connect to {}", (Throwable)e);
            this.setFailure(e);
        }
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    public synchronized Promise<S> setSuccess(S result) {
        LOG.debug("Promise {} completed", (Object)this);
        this.strategy.reconnectSuccessful();
        return super.setSuccess(result);
    }
}

