/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.opendaylight.protocol.framework.DeserializerException;
import org.opendaylight.protocol.framework.DocumentedException;
import org.opendaylight.protocol.framework.ProtocolMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class ProtocolMessageDecoder<T>
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolMessageDecoder.class);
    private final ProtocolMessageFactory<T> factory;

    public ProtocolMessageDecoder(ProtocolMessageFactory<T> factory) {
        this.factory = (ProtocolMessageFactory)Preconditions.checkNotNull(factory);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() == 0) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        in.markReaderIndex();
        try {
            LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
            byte[] bytes = new byte[in.readableBytes()];
            in.readBytes(bytes);
            out.add(this.factory.parse(bytes));
        }
        catch (DeserializerException | DocumentedException e) {
            LOG.debug("Failed to decode protocol message", (Throwable)e);
            this.exceptionCaught(ctx, e);
        }
        in.discardReadBytes();
    }
}

