/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import org.opendaylight.protocol.framework.AbstractProtocolSession;
import org.opendaylight.protocol.framework.SessionNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionNegotiator<M, S extends AbstractProtocolSession<?>>
extends ChannelInboundHandlerAdapter
implements SessionNegotiator<S> {
    private final Logger logger = LoggerFactory.getLogger(AbstractSessionNegotiator.class);
    private final Promise<S> promise;
    protected final Channel channel;

    public AbstractSessionNegotiator(Promise<S> promise, Channel channel) {
        this.promise = (Promise)Preconditions.checkNotNull(promise);
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel);
    }

    protected abstract void startNegotiation() throws Exception;

    protected abstract void handleMessage(M var1) throws Exception;

    protected final void negotiationSuccessful(S session) {
        this.logger.debug("Negotiation on channel {} successful with session {}", (Object)this.channel, session);
        this.channel.pipeline().replace((ChannelHandler)this, "session", session);
        this.promise.setSuccess(session);
    }

    protected final void negotiationFailed(Throwable cause) {
        this.logger.debug("Negotiation on channel {} failed", (Object)this.channel, (Object)cause);
        this.channel.close();
        this.promise.setFailure(cause);
    }

    public final void channelActive(ChannelHandlerContext ctx) {
        this.logger.debug("Starting session negotiation on channel {}", (Object)this.channel);
        try {
            this.startNegotiation();
        }
        catch (Exception e) {
            this.logger.warn("Unexpected negotiation failure", (Throwable)e);
            this.negotiationFailed(e);
        }
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.logger.debug("Negotiation read invoked on channel {}", (Object)this.channel);
        try {
            this.handleMessage(msg);
        }
        catch (Exception e) {
            this.logger.debug("Unexpected error while handling negotiation message {}", msg, (Object)e);
            this.negotiationFailed(e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.info("Unexpected error during negotiation", cause);
        this.negotiationFailed(cause);
    }
}

