/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolSession<M>
extends SimpleChannelInboundHandler<Object>
implements ProtocolSession<M> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProtocolSession.class);

    protected abstract void handleMessage(M var1);

    protected abstract void endOfInput();

    protected abstract void sessionUp();

    public final void channelInactive(ChannelHandlerContext ctx) {
        LOG.debug("Channel {} inactive.", (Object)ctx.channel());
        this.endOfInput();
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) {
        LOG.debug("Message was received: {}", msg);
        this.handleMessage(msg);
    }

    public final void handlerAdded(ChannelHandlerContext ctx) {
        this.sessionUp();
    }
}

