/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.framework;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.opendaylight.protocol.framework.ProtocolSessionPromise;
import org.opendaylight.protocol.framework.ReconnectPromise;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategyFactory;
import org.opendaylight.protocol.framework.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcher<S extends ProtocolSession<?>, L extends SessionListener<?, ?, ?>>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDispatcher.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final EventExecutor executor;

    protected AbstractDispatcher(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this((EventExecutor)GlobalEventExecutor.INSTANCE, bossGroup, workerGroup);
    }

    protected AbstractDispatcher(EventExecutor executor, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.bossGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)bossGroup);
        this.workerGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)workerGroup);
        this.executor = (EventExecutor)Preconditions.checkNotNull((Object)executor);
    }

    protected ChannelFuture createServer(InetSocketAddress address, final PipelineInitializer<S> initializer) {
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, new DefaultPromise(AbstractDispatcher.this.executor));
            }
        });
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture f = b.bind((SocketAddress)address);
        LOG.debug("Initiated server {} at {}.", (Object)f, (Object)address);
        return f;
    }

    protected Future<S> createClient(InetSocketAddress address, ReconnectStrategy strategy, final PipelineInitializer<S> initializer) {
        Bootstrap b = new Bootstrap();
        final ProtocolSessionPromise p = new ProtocolSessionPromise(this.executor, address, strategy, b);
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, p);
            }
        });
        p.connect();
        LOG.debug("Client created.");
        return p;
    }

    protected Future<Void> createReconnectingClient(InetSocketAddress address, ReconnectStrategyFactory connectStrategyFactory, ReconnectStrategy reestablishStrategy, PipelineInitializer<S> initializer) {
        ReconnectPromise p = new ReconnectPromise((EventExecutor)GlobalEventExecutor.INSTANCE, this, address, connectStrategyFactory, reestablishStrategy, initializer);
        p.connect();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void close() {
        try {
            this.workerGroup.shutdownGracefully();
        }
        finally {
            this.bossGroup.shutdownGracefully();
        }
    }

    protected static interface PipelineInitializer<S extends ProtocolSession<?>> {
        public void initializeChannel(SocketChannel var1, Promise<S> var2);
    }
}

