/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager.northbound;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.SwitchConfig;
import org.opendaylight.controller.switchmanager.northbound.NodeConnectorProperties;
import org.opendaylight.controller.switchmanager.northbound.NodeConnectors;
import org.opendaylight.controller.switchmanager.northbound.NodeProperties;
import org.opendaylight.controller.switchmanager.northbound.Nodes;

@Path(value="/")
public class SwitchNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private ISwitchManager getIfSwitchManagerService(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        boolean found = false;
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return switchManager;
    }

    @Path(value="/{containerName}/nodes")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Nodes.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Nodes getNodes(@PathParam(value="containerName") String containerName) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ArrayList<NodeProperties> res = new ArrayList<NodeProperties>();
        Set nodes = switchManager.getNodes();
        if (nodes == null) {
            return new Nodes(res);
        }
        for (Node node : nodes) {
            Map propMap = switchManager.getNodeProps(node);
            if (propMap == null) continue;
            HashSet<Property> props = new HashSet<Property>(propMap.values());
            NodeProperties nodeProps = new NodeProperties(node, props);
            res.add(nodeProps);
        }
        return new Nodes(res);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/property/{propertyName}/{propertyValue}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @TypeHint(value=Response.class)
    @StatusCodes(value={@ResponseCode(code=201, condition="Operation successful"), @ResponseCode(code=400, condition="The nodeId or configuration is invalid"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or node or configuration name is not found"), @ResponseCode(code=406, condition="The property cannot be configured in non-default container"), @ResponseCode(code=409, condition="Unable to update configuration due to cluster conflict or conflicting description property"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response addNodeProperty(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="propertyName") String propertyName, @PathParam(value="propertyValue") String propertyValue) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        this.handleNodeAvailability(containerName, nodeType, nodeId);
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Property prop = switchManager.createProperty(propertyName, propertyValue);
        if (prop == null) {
            throw new ResourceNotFoundException("Property with name " + propertyName + " does not exist.");
        }
        SwitchConfig switchConfig = switchManager.getSwitchConfig(node.toString());
        HashMap<String, Property> nodeProperties = switchConfig == null ? new HashMap<String, Property>() : new HashMap(switchConfig.getNodeProperties());
        nodeProperties.put(prop.getName(), prop);
        SwitchConfig newSwitchConfig = new SwitchConfig(node.toString(), nodeProperties);
        Status status = switchManager.updateNodeConfig(newSwitchConfig);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)("Property " + propertyName), (String)this.username, (String)"updated", (String)("of Node " + NorthboundUtils.getNodeDesc((Node)node, (ISwitchManager)switchManager)), (String)containerName);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/property/{propertyName}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="Property removed successfully"), @ResponseCode(code=400, condition="The nodeId or configuration is invalid"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or nodeId or configuration name is not found"), @ResponseCode(code=409, condition="Unable to delete property due to cluster conflict"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response deleteNodeProperty(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="propertyName") String propertyName) {
        Status status;
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        this.handleNodeAvailability(containerName, nodeType, nodeId);
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        SwitchConfig switchConfig = switchManager.getSwitchConfig(node.toString());
        if (switchConfig == null) {
            status = new Status(StatusCode.NOTFOUND, "Switch Configuration does not exist");
        } else {
            HashMap nodeProperties = new HashMap(switchConfig.getNodeProperties());
            if (!nodeProperties.containsKey(propertyName.toLowerCase())) {
                String msg = "Property " + propertyName + " does not exist or not configured for switch " + nodeId;
                status = new Status(StatusCode.NOTFOUND, msg);
            } else {
                nodeProperties.remove(propertyName.toLowerCase());
                SwitchConfig newSwitchConfig = new SwitchConfig(node.toString(), nodeProperties);
                status = switchManager.updateNodeConfig(newSwitchConfig);
                if (status.isSuccess()) {
                    NorthboundUtils.auditlog((String)("Property " + propertyName), (String)this.username, (String)"removed", (String)("of Node " + NorthboundUtils.getNodeDesc((Node)node, (ISwitchManager)switchManager)), (String)containerName);
                    return Response.noContent().build();
                }
            }
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=NodeConnectors.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public NodeConnectors getNodeConnectors(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        this.handleNodeAvailability(containerName, nodeType, nodeId);
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        ArrayList<NodeConnectorProperties> res = new ArrayList<NodeConnectorProperties>();
        Set ncs = switchManager.getNodeConnectors(node);
        if (ncs == null) {
            return null;
        }
        for (NodeConnector nc : ncs) {
            Map propMap = switchManager.getNodeConnectorProps(nc);
            if (propMap == null) continue;
            HashSet<Property> props = new HashSet<Property>(propMap.values());
            NodeConnectorProperties ncProps = new NodeConnectorProperties(nc, props);
            res.add(ncProps);
        }
        return new NodeConnectors(res);
    }

    @Path(value="/{containerName}/nodeconnector/{nodeType}/{nodeId}/{nodeConnectorType}/{nodeConnectorId}/property/{propertyName}/{propertyValue}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or nodeId or configuration name is not found"), @ResponseCode(code=409, condition="Unable to add property due to cluster conflict"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response addNodeConnectorProperty(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="nodeConnectorType") String nodeConnectorType, @PathParam(value="nodeConnectorId") String nodeConnectorId, @PathParam(value="propertyName") String propertyName, @PathParam(value="propertyValue") String propertyValue) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        this.handleNodeAvailability(containerName, nodeType, nodeId);
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        this.handleNodeConnectorAvailability(containerName, node, nodeConnectorType, nodeConnectorId);
        NodeConnector nc = NodeConnector.fromStringNoNode((String)nodeConnectorType, (String)nodeConnectorId, (Node)node);
        Property prop = switchManager.createProperty(propertyName, propertyValue);
        if (prop == null) {
            throw new ResourceNotFoundException(RestMessages.INVALIDDATA.toString());
        }
        Status ret = switchManager.addNodeConnectorProp(nc, prop);
        if (ret.isSuccess()) {
            NorthboundUtils.auditlog((String)("Property " + propertyName), (String)this.username, (String)"updated", (String)("of Node Connector " + NorthboundUtils.getPortName((NodeConnector)nc, (ISwitchManager)switchManager)), (String)containerName);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        throw new InternalServerErrorException(ret.getDescription());
    }

    @Path(value="/{containerName}/nodeconnector/{nodeType}/{nodeId}/{nodeConnectorType}/{nodeConnectorId}/property/{propertyName}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="Property removed successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or nodeId or configuration name is not found"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response deleteNodeConnectorProperty(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="nodeConnectorType") String nodeConnectorType, @PathParam(value="nodeConnectorId") String nodeConnectorId, @PathParam(value="propertyName") String propertyName) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        this.handleNodeAvailability(containerName, nodeType, nodeId);
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        this.handleNodeConnectorAvailability(containerName, node, nodeConnectorType, nodeConnectorId);
        NodeConnector nc = NodeConnector.fromStringNoNode((String)nodeConnectorType, (String)nodeConnectorId, (Node)node);
        Status ret = switchManager.removeNodeConnectorProp(nc, propertyName);
        if (ret.isSuccess()) {
            NorthboundUtils.auditlog((String)("Property " + propertyName), (String)this.username, (String)"removed", (String)("of Node Connector " + NorthboundUtils.getPortName((NodeConnector)nc, (ISwitchManager)switchManager)), (String)containerName);
            return Response.noContent().build();
        }
        throw new ResourceNotFoundException(ret.getDescription());
    }

    @Path(value="/{containerName}/save")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=500, condition="Failed to save switch configuration. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Response saveSwitchConfig(@PathParam(value="containerName") String containerName) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getIfSwitchManagerService(containerName);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status ret = switchManager.saveSwitchConfig();
        if (ret.isSuccess()) {
            return Response.ok().build();
        }
        throw new InternalServerErrorException(ret.getDescription());
    }

    private Node handleNodeAvailability(String containerName, String nodeType, String nodeId) {
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        if (node == null) {
            throw new ResourceNotFoundException(nodeId + " : " + RestMessages.NONODE.toString());
        }
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!sm.getNodes().contains(node)) {
            throw new ResourceNotFoundException(node.toString() + " : " + RestMessages.NONODE.toString());
        }
        return node;
    }

    private void handleNodeConnectorAvailability(String containerName, Node node, String nodeConnectorType, String nodeConnectorId) {
        NodeConnector nc = NodeConnector.fromStringNoNode((String)nodeConnectorType, (String)nodeConnectorId, (Node)node);
        if (nc == null) {
            throw new ResourceNotFoundException(nc + " : " + RestMessages.NORESOURCE.toString());
        }
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!sm.getNodeConnectors(node).contains(nc)) {
            throw new ResourceNotFoundException(nc.toString() + " : " + RestMessages.NORESOURCE.toString());
        }
    }

    private boolean isValidContainer(String containerName) {
        if (containerName.equals(GlobalConstants.DEFAULT.toString())) {
            return true;
        }
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString());
        }
        return containerManager.getContainerNames().contains(containerName);
    }
}

