/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.util.NodeBuilder;

public abstract class AbstractNodeBuilder<P extends Node<?>, T extends NodeBuilder<P, T>>
implements NodeBuilder<P, T> {
    private final Map<QName, String> attributes;
    private QName qName;

    public AbstractNodeBuilder() {
        this.attributes = new ConcurrentHashMap<QName, String>();
    }

    public AbstractNodeBuilder(QName nodeType, Map<QName, String> attributes) {
        this.qName = nodeType;
        this.attributes = new ConcurrentHashMap<QName, String>(attributes);
    }

    public AbstractNodeBuilder(QName nodeType) {
        this.qName = nodeType;
        this.attributes = new ConcurrentHashMap<QName, String>();
    }

    protected final T thisInstance() {
        return (T)this;
    }

    @Override
    public final T setQName(QName name) {
        this.qName = name;
        return this.thisInstance();
    }

    @Override
    public QName getQName() {
        return this.qName;
    }

    @Override
    public final T setAttribute(QName attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
        return this.thisInstance();
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public T setAttribute(String attrName, String attrValue) {
        this.attributes.put(QName.create((QName)this.qName, (String)attrName), attrValue);
        return this.thisInstance();
    }
}

