/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.impl.util.AbstractNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;

public abstract class AbstractCompositeNodeBuilder<P extends CompositeNode>
extends AbstractNodeBuilder<P, CompositeNodeBuilder<P>>
implements CompositeNodeBuilder<P> {
    final List<Node<?>> childNodes = new ArrayList();

    public AbstractCompositeNodeBuilder() {
    }

    public AbstractCompositeNodeBuilder(QName nodeType, Map<QName, String> attributes) {
        super(nodeType, attributes);
    }

    public AbstractCompositeNodeBuilder(QName nodeType, Iterable<? extends Node<?>> nodes) {
        super(nodeType);
    }

    @Override
    public AbstractCompositeNodeBuilder<P> add(Node<?> node) {
        this.childNodes.add((Node<?>)Preconditions.checkNotNull(node, (Object)"Node should not be null"));
        return this;
    }

    @Override
    public AbstractCompositeNodeBuilder<P> addAll(Iterable<? extends Node<?>> nodes) {
        Iterables.addAll(this.childNodes, (Iterable)((Iterable)Preconditions.checkNotNull(nodes, (Object)"Node should not be null")));
        return this;
    }

    @Override
    public CompositeNodeBuilder<P> addLeaf(String leafLocalName, String leafValue) {
        return this.addLeaf(QName.create((QName)this.getQName(), (String)leafLocalName), leafValue);
    }

    public List<Node<?>> getChildNodes() {
        return this.childNodes;
    }
}

