/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec.xml;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.AttributesContainer;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlCodecProvider;
import org.opendaylight.yangtools.yang.data.impl.util.CompositeNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlDocumentUtils {
    private static final XmlCodecProvider DEFAULT_XML_VALUE_CODEC_PROVIDER = new XmlCodecProvider(){

        @Override
        public TypeDefinitionAwareCodec<Object, ? extends TypeDefinition<?>> codecFor(TypeDefinition<?> baseType) {
            return TypeDefinitionAwareCodec.from(baseType);
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(XmlDocumentUtils.class);

    public static Document toDocument(CompositeNode data, DataNodeContainer schema, XmlCodecProvider codecProvider) throws UnsupportedDataTypeException {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)schema);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder bob = dbf.newDocumentBuilder();
            doc = bob.newDocument();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        if (schema instanceof ContainerSchemaNode || schema instanceof ListSchemaNode) {
            doc.appendChild(XmlDocumentUtils.createXmlRootElement(doc, data, (SchemaNode)schema, codecProvider));
            return doc;
        }
        throw new UnsupportedDataTypeException("Schema can be ContainerSchemaNode or ListSchemaNode. Other types are not supported yet.");
    }

    private static Element createXmlRootElement(Document doc, org.opendaylight.yangtools.yang.data.api.Node<?> data, SchemaNode schema, XmlCodecProvider codecProvider) throws UnsupportedDataTypeException {
        Element itemEl;
        block5: {
            block3: {
                block6: {
                    block4: {
                        itemEl = XmlDocumentUtils.createElementFor(doc, data);
                        if (!(data instanceof SimpleNode)) break block3;
                        if (!(schema instanceof LeafListSchemaNode)) break block4;
                        XmlDocumentUtils.writeValueByType(itemEl, (SimpleNode)data, ((LeafListSchemaNode)schema).getType(), (DataSchemaNode)schema, codecProvider);
                        break block5;
                    }
                    if (!(schema instanceof LeafSchemaNode)) break block6;
                    XmlDocumentUtils.writeValueByType(itemEl, (SimpleNode)data, ((LeafSchemaNode)schema).getType(), (DataSchemaNode)schema, codecProvider);
                    break block5;
                }
                Object value = data.getValue();
                if (value == null) break block5;
                itemEl.setTextContent(String.valueOf(value));
                break block5;
            }
            for (org.opendaylight.yangtools.yang.data.api.Node child : ((CompositeNode)data).getChildren()) {
                DataSchemaNode childSchema = null;
                if (schema != null) {
                    childSchema = XmlDocumentUtils.findFirstSchemaForNode(child, ((DataNodeContainer)schema).getChildNodes());
                    if (logger.isDebugEnabled() && childSchema == null) {
                        logger.debug("Probably the data node \"" + (child == null ? "" : child.getNodeType().getLocalName()) + "\" is not conform to schema");
                    }
                }
                itemEl.appendChild(XmlDocumentUtils.createXmlRootElement(doc, child, (SchemaNode)childSchema, codecProvider));
            }
        }
        return itemEl;
    }

    private static Element createElementFor(Document doc, org.opendaylight.yangtools.yang.data.api.Node<?> data) {
        QName dataType = data.getNodeType();
        Element ret = dataType.getNamespace() != null ? doc.createElementNS(dataType.getNamespace().toString(), dataType.getLocalName()) : doc.createElementNS(null, dataType.getLocalName());
        if (data instanceof AttributesContainer && ((AttributesContainer)data).getAttributes() != null) {
            for (Map.Entry attribute : ((AttributesContainer)data).getAttributes().entrySet()) {
                ret.setAttributeNS(((QName)attribute.getKey()).getNamespace().toString(), ((QName)attribute.getKey()).getLocalName(), (String)attribute.getValue());
            }
        }
        return ret;
    }

    public static void writeValueByType(Element element, SimpleNode<?> node, TypeDefinition<?> type, DataSchemaNode schema, XmlCodecProvider codecProvider) {
        TypeDefinition<?> baseType = XmlDocumentUtils.resolveBaseTypeFrom(type);
        if (baseType instanceof IdentityrefTypeDefinition) {
            if (node.getValue() instanceof QName) {
                QName value = (QName)node.getValue();
                String prefix = "x";
                if (value.getPrefix() != null && !value.getPrefix().isEmpty()) {
                    prefix = value.getPrefix();
                }
                element.setAttribute("xmlns:" + prefix, value.getNamespace().toString());
                element.setTextContent(prefix + ":" + value.getLocalName());
            } else {
                Object value = node.getValue();
                logger.debug("Value of {}:{} is not instance of QName but is {}", new Object[]{baseType.getQName().getNamespace(), baseType.getQName().getLocalName(), value != null ? value.getClass() : "null"});
                if (value != null) {
                    element.setTextContent(String.valueOf(value));
                }
            }
        } else if (baseType instanceof InstanceIdentifierTypeDefinition) {
            if (node.getValue() instanceof InstanceIdentifier) {
                HashMap<String, String> prefixes = new HashMap<String, String>();
                InstanceIdentifier instanceIdentifier = (InstanceIdentifier)node.getValue();
                StringBuilder textContent = new StringBuilder();
                for (InstanceIdentifier.PathArgument pathArgument : instanceIdentifier.getPath()) {
                    textContent.append("/");
                    XmlDocumentUtils.writeIdentifierWithNamespacePrefix(element, textContent, pathArgument.getNodeType(), prefixes);
                    if (!(pathArgument instanceof InstanceIdentifier.NodeIdentifierWithPredicates)) continue;
                    Map predicates = ((InstanceIdentifier.NodeIdentifierWithPredicates)pathArgument).getKeyValues();
                    for (QName keyValue : predicates.keySet()) {
                        String predicateValue = String.valueOf(predicates.get(keyValue));
                        textContent.append("[");
                        XmlDocumentUtils.writeIdentifierWithNamespacePrefix(element, textContent, keyValue, prefixes);
                        textContent.append("='");
                        textContent.append(predicateValue);
                        textContent.append("'");
                        textContent.append("]");
                    }
                }
                element.setTextContent(textContent.toString());
            } else {
                Object value = node.getValue();
                logger.debug("Value of {}:{} is not instance of InstanceIdentifier but is {}", new Object[]{baseType.getQName().getNamespace(), baseType.getQName().getLocalName(), value != null ? value.getClass() : "null"});
                if (value != null) {
                    element.setTextContent(String.valueOf(value));
                }
            }
        } else if (node.getValue() != null) {
            TypeDefinitionAwareCodec<Object, TypeDefinition<?>> codec = codecProvider.codecFor(baseType);
            if (codec != null) {
                try {
                    String text = codec.serialize((TypeDefinition<?>)node.getValue());
                    element.setTextContent(text);
                }
                catch (ClassCastException e) {
                    logger.error("Provided node did not have type required by mapping. Using stream instead.", (Throwable)e);
                    element.setTextContent(String.valueOf(node.getValue()));
                }
            } else {
                logger.error("Failed to find codec for {}, falling back to using stream", baseType);
                element.setTextContent(String.valueOf(node.getValue()));
            }
        }
    }

    private static void writeIdentifierWithNamespacePrefix(Element element, StringBuilder textContent, QName qName, Map<String, String> prefixes) {
        String namespace = qName.getNamespace().toString();
        String prefix = prefixes.get(namespace);
        if (prefix == null && ((prefix = qName.getPrefix()) == null || prefix.isEmpty() || prefixes.containsValue(prefix))) {
            prefix = XmlDocumentUtils.generateNewPrefix(prefixes.values());
        }
        element.setAttribute("xmlns:" + prefix, namespace.toString());
        textContent.append(prefix);
        prefixes.put(namespace, prefix);
        textContent.append(":");
        textContent.append(qName.getLocalName());
    }

    private static String generateNewPrefix(Collection<String> prefixes) {
        StringBuilder result = null;
        Random random = new Random();
        do {
            result = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                int randomNumber = 97 + Math.abs(random.nextInt()) % 26;
                result.append(Character.toChars(randomNumber));
            }
        } while (prefixes.contains(result.toString()));
        return result.toString();
    }

    public static final TypeDefinition<?> resolveBaseTypeFrom(TypeDefinition<?> type) {
        TypeDefinition superType = type;
        while (superType.getBaseType() != null) {
            superType = superType.getBaseType();
        }
        return superType;
    }

    private static final DataSchemaNode findFirstSchemaForNode(org.opendaylight.yangtools.yang.data.api.Node<?> node, Set<DataSchemaNode> dataSchemaNode) {
        if (dataSchemaNode != null && node != null) {
            for (DataSchemaNode dsn : dataSchemaNode) {
                if (node.getNodeType().getLocalName().equals(dsn.getQName().getLocalName())) {
                    return dsn;
                }
                if (!(dsn instanceof ChoiceNode)) continue;
                for (ChoiceCaseNode choiceCase : ((ChoiceNode)dsn).getCases()) {
                    DataSchemaNode foundDsn = XmlDocumentUtils.findFirstSchemaForNode(node, choiceCase.getChildNodes());
                    if (foundDsn == null) continue;
                    return foundDsn;
                }
            }
        }
        return null;
    }

    public static org.opendaylight.yangtools.yang.data.api.Node<?> toDomNode(Element xmlElement, Optional<DataSchemaNode> schema, Optional<XmlCodecProvider> codecProvider) {
        if (schema.isPresent()) {
            return XmlDocumentUtils.toNodeWithSchema(xmlElement, (DataSchemaNode)schema.get(), (XmlCodecProvider)codecProvider.or((Object)DEFAULT_XML_VALUE_CODEC_PROVIDER));
        }
        return XmlDocumentUtils.toDomNode(xmlElement);
    }

    public static CompositeNode fromElement(Element xmlElement) {
        CompositeNodeBuilder<ImmutableCompositeNode> node = ImmutableCompositeNode.builder();
        node.setQName(XmlDocumentUtils.qNameFromElement(xmlElement));
        return (CompositeNode)node.toInstance();
    }

    private static QName qNameFromElement(Element xmlElement) {
        String namespace = xmlElement.getNamespaceURI();
        String localName = xmlElement.getLocalName();
        return QName.create((URI)(namespace != null ? URI.create(namespace) : null), null, (String)localName);
    }

    private static org.opendaylight.yangtools.yang.data.api.Node<?> toNodeWithSchema(Element xmlElement, DataSchemaNode schema, XmlCodecProvider codecProvider) {
        XmlDocumentUtils.checkQName(xmlElement, schema.getQName());
        if (schema instanceof DataNodeContainer) {
            return XmlDocumentUtils.toCompositeNodeWithSchema(xmlElement, schema.getQName(), (DataNodeContainer)schema, codecProvider);
        }
        if (schema instanceof LeafSchemaNode) {
            return XmlDocumentUtils.toSimpleNodeWithType(xmlElement, (LeafSchemaNode)schema, codecProvider);
        }
        if (schema instanceof LeafListSchemaNode) {
            return XmlDocumentUtils.toSimpleNodeWithType(xmlElement, (LeafListSchemaNode)schema, codecProvider);
        }
        return null;
    }

    private static org.opendaylight.yangtools.yang.data.api.Node<?> toSimpleNodeWithType(Element xmlElement, LeafSchemaNode schema, XmlCodecProvider codecProvider) {
        TypeDefinitionAwareCodec<Object, TypeDefinition<?>> codec = codecProvider.codecFor(schema.getType());
        String text = xmlElement.getTextContent();
        String value = codec != null ? codec.deserialize(text) : xmlElement.getTextContent();
        return new SimpleNodeTOImpl<String>(schema.getQName(), null, value);
    }

    private static org.opendaylight.yangtools.yang.data.api.Node<?> toSimpleNodeWithType(Element xmlElement, LeafListSchemaNode schema, XmlCodecProvider codecProvider) {
        TypeDefinitionAwareCodec<Object, TypeDefinition<?>> codec = codecProvider.codecFor(schema.getType());
        String text = xmlElement.getTextContent();
        String value = codec != null ? codec.deserialize(text) : xmlElement.getTextContent();
        return new SimpleNodeTOImpl<String>(schema.getQName(), null, value);
    }

    private static org.opendaylight.yangtools.yang.data.api.Node<?> toCompositeNodeWithSchema(Element xmlElement, QName qName, DataNodeContainer schema, XmlCodecProvider codecProvider) {
        List<org.opendaylight.yangtools.yang.data.api.Node<?>> values = XmlDocumentUtils.toDomNodes(xmlElement, (Optional<Set<DataSchemaNode>>)Optional.fromNullable((Object)schema.getChildNodes()));
        return ImmutableCompositeNode.create(qName, values);
    }

    private static void checkQName(Element xmlElement, QName qName) {
        Preconditions.checkState((boolean)Objects.equal((Object)xmlElement.getNamespaceURI(), (Object)qName.getNamespace().toString()));
        Preconditions.checkState((boolean)qName.getLocalName().equals(xmlElement.getLocalName()));
    }

    private static final Optional<DataSchemaNode> findFirstSchema(QName qname, Set<DataSchemaNode> dataSchemaNode) {
        if (dataSchemaNode != null && !dataSchemaNode.isEmpty() && qname != null) {
            for (DataSchemaNode dsn : dataSchemaNode) {
                if (qname.isEqualWithoutRevision(dsn.getQName())) {
                    return Optional.of((Object)dsn);
                }
                if (!(dsn instanceof ChoiceNode)) continue;
                for (ChoiceCaseNode choiceCase : ((ChoiceNode)dsn).getCases()) {
                    Optional<DataSchemaNode> foundDsn = XmlDocumentUtils.findFirstSchema(qname, choiceCase.getChildNodes());
                    if (foundDsn == null || !foundDsn.isPresent()) continue;
                    return foundDsn;
                }
            }
        }
        return Optional.absent();
    }

    public static org.opendaylight.yangtools.yang.data.api.Node<?> toDomNode(Document doc) {
        return XmlDocumentUtils.toDomNode(doc.getDocumentElement());
    }

    private static org.opendaylight.yangtools.yang.data.api.Node<?> toDomNode(Element element) {
        QName qname = XmlDocumentUtils.qNameFromElement(element);
        ImmutableList.Builder values = ImmutableList.builder();
        NodeList nodes = element.getChildNodes();
        boolean isSimpleObject = true;
        String value = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child instanceof Element) {
                isSimpleObject = false;
                values.add(XmlDocumentUtils.toDomNode((Element)child));
            }
            if (!isSimpleObject || !(child instanceof Text) || Strings.isNullOrEmpty((String)(value = element.getTextContent()))) continue;
            isSimpleObject = true;
        }
        if (isSimpleObject) {
            return new SimpleNodeTOImpl<Object>(qname, null, value);
        }
        return ImmutableCompositeNode.create(qname, values.build());
    }

    public static List<org.opendaylight.yangtools.yang.data.api.Node<?>> toDomNodes(Element element, final Optional<Set<DataSchemaNode>> context) {
        return XmlDocumentUtils.forEachChild(element.getChildNodes(), new Function<Element, Optional<org.opendaylight.yangtools.yang.data.api.Node<?>>>(){

            public Optional<org.opendaylight.yangtools.yang.data.api.Node<?>> apply(Element input) {
                QName partialQName;
                Optional schemaNode;
                if (context.isPresent() && (schemaNode = XmlDocumentUtils.findFirstSchema(partialQName = XmlDocumentUtils.qNameFromElement(input), (Set)context.get())).isPresent()) {
                    return Optional.fromNullable((Object)XmlDocumentUtils.toNodeWithSchema(input, (DataSchemaNode)schemaNode.get(), DEFAULT_XML_VALUE_CODEC_PROVIDER));
                }
                return Optional.fromNullable((Object)XmlDocumentUtils.toDomNode(input));
            }
        });
    }

    public static CompositeNode notificationToDomNodes(Document document, Optional<Set<NotificationDefinition>> notifications) {
        if (notifications.isPresent() && document != null && document.getDocumentElement() != null) {
            NodeList originChildNodes = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < originChildNodes.getLength(); ++i) {
                Element childElement;
                QName partialQName;
                Optional<NotificationDefinition> notificationDef;
                Node child = originChildNodes.item(i);
                if (!(child instanceof Element) || !(notificationDef = XmlDocumentUtils.findNotification(partialQName = XmlDocumentUtils.qNameFromElement(childElement = (Element)child), (Set)notifications.get())).isPresent()) continue;
                Set dataNodes = ((NotificationDefinition)notificationDef.get()).getChildNodes();
                List<org.opendaylight.yangtools.yang.data.api.Node<?>> domNodes = XmlDocumentUtils.toDomNodes(childElement, (Optional<Set<DataSchemaNode>>)Optional.fromNullable((Object)dataNodes));
                return ImmutableCompositeNode.create(((NotificationDefinition)notificationDef.get()).getQName(), domNodes);
            }
        }
        return null;
    }

    private static Optional<NotificationDefinition> findNotification(QName notifName, Set<NotificationDefinition> notifications) {
        if (notifName != null && notifications != null) {
            for (NotificationDefinition notification : notifications) {
                if (notification == null || !notifName.isEqualWithoutRevision(notification.getQName())) continue;
                return Optional.fromNullable((Object)notification);
            }
        }
        return Optional.absent();
    }

    private static final <T> List<T> forEachChild(NodeList nodes, Function<Element, Optional<T>> forBody) {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Optional result;
            Node child = nodes.item(i);
            if (!(child instanceof Element) || !(result = (Optional)forBody.apply((Object)((Element)child))).isPresent()) continue;
            ret.add(result.get());
        }
        return ret.build();
    }

    public static final XmlCodecProvider defaultValueCodecProvider() {
        return DEFAULT_XML_VALUE_CODEC_PROVIDER;
    }
}

