/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;

public final class XmlTreeBuilder {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static XMLEventReader eventReader;

    private XmlTreeBuilder() {
    }

    public static Node<?> buildDataTree(InputStream inputStream) throws XMLStreamException {
        eventReader = xmlInputFactory.createXMLEventReader(inputStream);
        Stack<SimpleNode<String>> processingQueue = new Stack<SimpleNode<String>>();
        Node parentNode = null;
        Node root = null;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                if (!processingQueue.isEmpty()) {
                    parentNode = (Node)processingQueue.peek();
                }
                MutableCompositeNode compParentNode = null;
                if (parentNode instanceof MutableCompositeNode) {
                    compParentNode = (MutableCompositeNode)parentNode;
                }
                SimpleNode<String> newNode = null;
                if (XmlTreeBuilder.isCompositeNodeEvent(event)) {
                    newNode = XmlTreeBuilder.resolveCompositeNodeFromStartElement(startElement, (CompositeNode)compParentNode);
                } else if (XmlTreeBuilder.isSimpleNodeEvent(event)) {
                    newNode = XmlTreeBuilder.resolveSimpleNodeFromStartElement(startElement, (CompositeNode)compParentNode);
                }
                if (newNode == null) continue;
                processingQueue.push(newNode);
                if (compParentNode == null) continue;
                compParentNode.getChildren().add(newNode);
                continue;
            }
            if (!event.isEndElement() || !((root = (Node)processingQueue.pop()) instanceof MutableCompositeNode)) continue;
            ((MutableCompositeNode)root).init();
        }
        return root;
    }

    private static boolean isSimpleNodeEvent(XMLEvent event) throws XMLStreamException {
        Characters chars;
        XMLEvent innerEvent;
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"XML Event cannot be NULL!");
        return event.isStartElement() && eventReader.hasNext() && ((innerEvent = eventReader.peek()).isCharacters() ? !(chars = innerEvent.asCharacters()).isWhiteSpace() : innerEvent.isEndElement());
    }

    private static boolean isCompositeNodeEvent(XMLEvent event) throws XMLStreamException {
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"XML Event cannot be NULL!");
        if (event.isStartElement() && eventReader.hasNext()) {
            Characters chars;
            XMLEvent innerEvent = eventReader.peek();
            if (innerEvent.isCharacters() && (chars = innerEvent.asCharacters()).isWhiteSpace()) {
                eventReader.nextEvent();
                innerEvent = eventReader.peek();
            }
            if (innerEvent.isStartElement()) {
                return true;
            }
        }
        return false;
    }

    private static SimpleNode<String> resolveSimpleNodeFromStartElement(StartElement startElement, CompositeNode parent) throws XMLStreamException {
        Preconditions.checkArgument((startElement != null ? 1 : 0) != 0, (Object)"Start Element cannot be NULL!");
        String data = null;
        if (eventReader.hasNext()) {
            XMLEvent innerEvent = eventReader.peek();
            if (innerEvent.isCharacters()) {
                Characters chars = innerEvent.asCharacters();
                if (!chars.isWhiteSpace()) {
                    data = innerEvent.asCharacters().getData();
                }
            } else if (innerEvent.isEndElement()) {
                data = "";
            }
        }
        return NodeFactory.createImmutableSimpleNode(XmlTreeBuilder.resolveElementQName(startElement), parent, data);
    }

    private static MutableCompositeNode resolveCompositeNodeFromStartElement(StartElement startElement, CompositeNode parent) {
        Preconditions.checkArgument((startElement != null ? 1 : 0) != 0, (Object)"Start Element cannot be NULL!");
        return NodeFactory.createMutableCompositeNode(XmlTreeBuilder.resolveElementQName(startElement), parent, new ArrayList(), ModifyAction.CREATE, null);
    }

    private static QName resolveElementQName(StartElement element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"Start Element cannot be NULL!");
        String nsURI = element.getName().getNamespaceURI();
        String localName = element.getName().getLocalPart();
        return new QName(URI.create(nsURI), localName);
    }
}

