/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.NodeModification;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.AbstractNodeTO;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NodeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NodeUtils.class);
    private static final String USER_KEY_NODE = "node";

    public static String buildPath(org.opendaylight.yangtools.yang.data.api.Node<?> node) {
        ArrayList<String> breadCrumbs = new ArrayList<String>();
        for (CompositeNode tmpNode = node; tmpNode != null; tmpNode = tmpNode.getParent()) {
            breadCrumbs.add(0, tmpNode.getNodeType().getLocalName());
        }
        return Joiner.on((String)".").join(breadCrumbs);
    }

    public static Document buildShadowDomTree(CompositeNode treeRootNode) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder bob = dbf.newDocumentBuilder();
            doc = bob.newDocument();
        }
        catch (ParserConfigurationException e) {
            LOG.error("documentBuilder problem", (Throwable)e);
            return null;
        }
        Stack<AbstractMap.SimpleEntry<Node, Object>> jobQueue = new Stack<AbstractMap.SimpleEntry<Node, Object>>();
        jobQueue.push(new AbstractMap.SimpleEntry<Document, CompositeNode>(doc, treeRootNode));
        while (!jobQueue.isEmpty()) {
            ModifyAction modificationAction;
            Object value;
            AbstractMap.SimpleEntry job = (AbstractMap.SimpleEntry)jobQueue.pop();
            Node jointPlace = (Node)job.getKey();
            org.opendaylight.yangtools.yang.data.api.Node item = (org.opendaylight.yangtools.yang.data.api.Node)job.getValue();
            QName nodeType = item.getNodeType();
            Element itemEl = doc.createElementNS(nodeType.getNamespace().toString(), item.getNodeType().getLocalName());
            itemEl.setUserData(USER_KEY_NODE, item, null);
            if (item instanceof SimpleNode && (value = ((SimpleNode)item).getValue()) != null) {
                itemEl.setTextContent(String.valueOf(value));
            }
            if (item instanceof NodeModification && (modificationAction = ((NodeModification)item).getModificationAction()) != null) {
                itemEl.setAttribute("modifyAction", modificationAction.toString());
            }
            jointPlace.appendChild(itemEl);
            if (!(item instanceof CompositeNode)) continue;
            for (org.opendaylight.yangtools.yang.data.api.Node child : ((CompositeNode)item).getChildren()) {
                jobQueue.push(new AbstractMap.SimpleEntry<Element, org.opendaylight.yangtools.yang.data.api.Node>(itemEl, child));
            }
        }
        return doc;
    }

    public static <T> T findNodeByXpath(Document doc, String xpathEx) throws XPathExpressionException {
        Object userNode = null;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathEx);
        Node result = (Node)expr.evaluate(doc, XPathConstants.NODE);
        if (result != null) {
            userNode = result.getUserData(USER_KEY_NODE);
        }
        return (T)userNode;
    }

    public static Map<QName, List<org.opendaylight.yangtools.yang.data.api.Node<?>>> buildNodeMap(List<org.opendaylight.yangtools.yang.data.api.Node<?>> value) {
        HashMap nodeMapTmp = new HashMap();
        if (value == null) {
            throw new IllegalStateException("nodeList should not be null or empty");
        }
        for (org.opendaylight.yangtools.yang.data.api.Node<?> node : value) {
            ArrayList qList = (ArrayList)nodeMapTmp.get(node.getNodeType());
            if (qList == null) {
                qList = new ArrayList();
                nodeMapTmp.put(node.getNodeType(), qList);
            }
            qList.add(node);
        }
        return nodeMapTmp;
    }

    public static Map<String, ListSchemaNode> buildMapOfListNodes(SchemaContext context) {
        HashMap<String, ListSchemaNode> mapOfLists = new HashMap<String, ListSchemaNode>();
        Stack jobQueue = new Stack();
        jobQueue.addAll(context.getDataDefinitions());
        while (!jobQueue.isEmpty()) {
            DataSchemaNode dataSchema = (DataSchemaNode)jobQueue.pop();
            if (dataSchema instanceof ListSchemaNode) {
                mapOfLists.put(NodeUtils.schemaPathToPath(dataSchema.getPath().getPath()), (ListSchemaNode)dataSchema);
            }
            if (!(dataSchema instanceof DataNodeContainer)) continue;
            jobQueue.addAll(((DataNodeContainer)dataSchema).getChildNodes());
        }
        return mapOfLists;
    }

    private static String schemaPathToPath(List<QName> qNamesPath) {
        ArrayList<String> pathSeed = new ArrayList<String>();
        for (QName qNameItem : qNamesPath) {
            pathSeed.add(qNameItem.getLocalName());
        }
        return Joiner.on((String)".").join(pathSeed);
    }

    public static void fixParentRelation(org.opendaylight.yangtools.yang.data.api.Node<?> newNode) {
        List siblings;
        if (newNode.getParent() != null && !(siblings = newNode.getParent().getChildren()).contains(newNode)) {
            siblings.add(newNode);
        }
    }

    public static void fixChildrenRelation(CompositeNode parentNode) {
        if (parentNode.getChildren() != null) {
            for (org.opendaylight.yangtools.yang.data.api.Node child : parentNode.getChildren()) {
                if (!(child instanceof AbstractNodeTO)) continue;
                ((AbstractNodeTO)child).setParent(parentNode);
            }
        }
    }

    public static <T, K> List<K> collectMapValues(List<T> keys, Map<T, K> dataMap) {
        ArrayList<K> valueSubList = new ArrayList<K>();
        for (T key : keys) {
            valueSubList.add(dataMap.get(key));
        }
        return valueSubList;
    }

    public static List<org.opendaylight.yangtools.yang.data.api.Node<?>> buildChildrenList(org.opendaylight.yangtools.yang.data.api.Node<?> ... nodes) {
        return Lists.newArrayList((Object[])nodes);
    }
}

