/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableNode;
import org.opendaylight.yangtools.yang.data.api.MutableSimpleNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.NodeModificationBuilder;
import org.opendaylight.yangtools.yang.data.impl.LazyNodeToNodeMap;
import org.opendaylight.yangtools.yang.data.impl.NodeUtils;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class NodeModificationBuilderImpl
implements NodeModificationBuilder {
    private SchemaContext context;
    private Set<MutableNode<?>> changeLog;
    private LazyNodeToNodeMap originalToMutable;

    public NodeModificationBuilderImpl(SchemaContext context) {
        this.context = context;
        this.originalToMutable = new LazyNodeToNodeMap();
        this.changeLog = new HashSet();
    }

    private void addModificationToLog(MutableNode<?> modNode, ModifyAction action) {
        modNode.setModifyAction(action);
        this.changeLog.add(modNode);
    }

    public void addNode(MutableSimpleNode<?> newNode) {
        NodeUtils.fixParentRelation(newNode);
        this.addModificationToLog((MutableNode<?>)newNode, ModifyAction.CREATE);
    }

    public void addNode(MutableCompositeNode newNode) {
        NodeUtils.fixParentRelation(newNode);
        this.addModificationToLog((MutableNode<?>)newNode, ModifyAction.CREATE);
    }

    public void replaceNode(MutableSimpleNode<?> replacementNode) {
        this.addModificationToLog((MutableNode<?>)replacementNode, ModifyAction.REPLACE);
    }

    public void replaceNode(MutableCompositeNode replacementNode) {
        this.addModificationToLog((MutableNode<?>)replacementNode, ModifyAction.REPLACE);
    }

    public void deleteNode(MutableCompositeNode deadNode) {
        this.addModificationToLog((MutableNode<?>)deadNode, ModifyAction.DELETE);
    }

    public void deleteNode(MutableSimpleNode<?> deadNode) {
        this.addModificationToLog((MutableNode<?>)deadNode, ModifyAction.DELETE);
    }

    public void removeNode(MutableSimpleNode<?> deadNode) {
        this.addModificationToLog((MutableNode<?>)deadNode, ModifyAction.REMOVE);
    }

    public void removeNode(MutableCompositeNode deadNode) {
        this.addModificationToLog((MutableNode<?>)deadNode, ModifyAction.REMOVE);
    }

    public void mergeNode(MutableCompositeNode alteredNode) {
        this.addModificationToLog((MutableNode<?>)alteredNode, ModifyAction.MERGE);
    }

    public CompositeNode buildDiffTree() {
        HashSet wanted = new HashSet();
        for (MutableNode<?> mutant : this.changeLog) {
            wanted.addAll(NodeModificationBuilderImpl.collectSelfAndAllParents(mutant));
        }
        Map<String, ListSchemaNode> mapOfLists = NodeUtils.buildMapOfListNodes(this.context);
        for (Node node : wanted) {
            ListSchemaNode listSchema;
            String path;
            if (!(node instanceof CompositeNode) || !mapOfLists.containsKey(path = NodeUtils.buildPath(node)) || !(listSchema = mapOfLists.get(path)).getQName().equals((Object)node.getNodeType())) continue;
            List supportedKeys = listSchema.getKeyDefinition();
            CompositeNode outlawOriginal = ((MutableCompositeNode)node).getOriginal();
            for (Node outlawOriginalChild : outlawOriginal.getChildren()) {
                if (!supportedKeys.contains(outlawOriginalChild.getNodeType())) continue;
                this.originalToMutable.getMutableEquivalent(outlawOriginalChild);
            }
        }
        return this.originalToMutable.getMutableRoot();
    }

    private static Set<Node<?>> collectSelfAndAllParents(Node<?> focusedDescendant) {
        HashSet family = new HashSet();
        for (CompositeNode tmpNode = focusedDescendant; tmpNode != null; tmpNode = tmpNode.getParent()) {
            family.add((Node<?>)tmpNode);
        }
        return family;
    }

    public Node<?> getMutableEquivalent(Node<?> originalNode) {
        return this.originalToMutable.getMutableEquivalent(originalNode);
    }
}

