/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableSimpleNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.NodeModification;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.CompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.MutableCompositeNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.MutableSimpleNodeTOImpl;
import org.opendaylight.yangtools.yang.data.impl.NodeUtils;
import org.opendaylight.yangtools.yang.data.impl.SimpleNodeTOImpl;

public abstract class NodeFactory {
    public static <T> SimpleNode<T> createImmutableSimpleNode(QName qName, CompositeNode parent, T value) {
        return NodeFactory.createImmutableSimpleNode(qName, parent, value, null);
    }

    public static <T> MutableSimpleNode<T> createMutableSimpleNode(QName qName, CompositeNode parent, Object value, ModifyAction modifyAction, SimpleNode<T> original) {
        MutableSimpleNodeTOImpl<Object> simpleNodeTOImpl = new MutableSimpleNodeTOImpl<Object>(qName, parent, value, modifyAction);
        simpleNodeTOImpl.setOriginal(original);
        return simpleNodeTOImpl;
    }

    public static CompositeNode createImmutableCompositeNode(QName qName, CompositeNode parent, List<Node<?>> value) {
        return NodeFactory.createImmutableCompositeNode(qName, parent, value, null);
    }

    public static MutableCompositeNode createMutableCompositeNode(QName qName, CompositeNode parent, List<Node<?>> valueArg, ModifyAction modifyAction, CompositeNode original) {
        List<Node<?>> value = valueArg;
        if (value == null) {
            value = new ArrayList();
        }
        MutableCompositeNodeTOImpl compositeNodeTOImpl = new MutableCompositeNodeTOImpl(qName, parent, value, modifyAction);
        compositeNodeTOImpl.setOriginal(original);
        return compositeNodeTOImpl;
    }

    public static <T> SimpleNode<T> createImmutableSimpleNode(QName qName, CompositeNode parent, T value, ModifyAction modifyAction) {
        SimpleNodeTOImpl<T> simpleNodeModTOImpl = new SimpleNodeTOImpl<T>(qName, parent, value, modifyAction);
        return simpleNodeModTOImpl;
    }

    public static CompositeNode createImmutableCompositeNode(QName qName, CompositeNode parent, List<Node<?>> value, ModifyAction modifyAction) {
        CompositeNodeTOImpl compositeNodeModTOImpl = new CompositeNodeTOImpl(qName, parent, value, modifyAction);
        return compositeNodeModTOImpl;
    }

    public static <T> SimpleNode<T> copyNode(SimpleNode<T> node) {
        SimpleNode<Object> twinNode = NodeFactory.createImmutableSimpleNode(node.getNodeType(), node.getParent(), node.getValue());
        return twinNode;
    }

    public static <T> MutableSimpleNode<T> copyNodeAsMutable(SimpleNode<T> node) {
        MutableSimpleNode<T> twinNode = NodeFactory.createMutableSimpleNode(node.getNodeType(), node.getParent(), node.getValue(), node.getModificationAction(), null);
        return twinNode;
    }

    public static CompositeNode copyNode(CompositeNode node, Node<?> ... children) {
        CompositeNode twinNode = NodeFactory.createImmutableCompositeNode(node.getNodeType(), node.getParent(), Arrays.asList(children), node.getModificationAction());
        return twinNode;
    }

    public static CompositeNode copyNode(CompositeNode node) {
        return NodeFactory.copyNode(node, node.getChildren().toArray(new Node[0]));
    }

    public static MutableCompositeNode copyDeepAsMutable(CompositeNode node, Map<Node<?>, Node<?>> originalToCopyArg) {
        Map<Node<?>, Node<?>> originalToCopy = originalToCopyArg;
        if (originalToCopy == null) {
            originalToCopy = new HashMap();
        }
        MutableCompositeNode mutableRoot = NodeFactory.createMutableCompositeNode(node.getNodeType(), null, null, node.getModificationAction(), null);
        Stack<AbstractMap.SimpleEntry<CompositeNode, MutableCompositeNode>> jobQueue = new Stack<AbstractMap.SimpleEntry<CompositeNode, MutableCompositeNode>>();
        jobQueue.push(new AbstractMap.SimpleEntry<CompositeNode, MutableCompositeNode>(node, mutableRoot));
        originalToCopy.put((Node<?>)node, (Node<?>)mutableRoot);
        while (!jobQueue.isEmpty()) {
            AbstractMap.SimpleEntry job = (AbstractMap.SimpleEntry)jobQueue.pop();
            CompositeNode originalNode = (CompositeNode)job.getKey();
            MutableCompositeNode mutableNode = (MutableCompositeNode)job.getValue();
            mutableNode.setValue(new ArrayList());
            for (Node child : originalNode.getChildren()) {
                MutableCompositeNode mutableAscendant = null;
                if (child instanceof CompositeNode) {
                    MutableCompositeNode newMutable = NodeFactory.createMutableCompositeNode(child.getNodeType(), (CompositeNode)mutableNode, null, ((NodeModification)child).getModificationAction(), null);
                    jobQueue.push(new AbstractMap.SimpleEntry<CompositeNode, MutableCompositeNode>((CompositeNode)child, newMutable));
                    mutableAscendant = newMutable;
                } else if (child instanceof SimpleNode) {
                    mutableAscendant = NodeFactory.createMutableSimpleNode(child.getNodeType(), (CompositeNode)mutableNode, child.getValue(), ((NodeModification)child).getModificationAction(), null);
                } else {
                    throw new IllegalStateException("Node class deep copy not supported: " + child.getClass().getName());
                }
                mutableNode.getChildren().add(mutableAscendant);
                originalToCopy.put((Node<?>)child, (Node<?>)mutableAscendant);
            }
            mutableNode.init();
        }
        return mutableRoot;
    }

    public static CompositeNode copyDeepAsImmutable(CompositeNode node, Map<Node<?>, Node<?>> originalToCopyArg) {
        Stack<CompositeNode> jobQueue = new Stack<CompositeNode>();
        jobQueue.push(node);
        Map<Node<?>, Node<?>> originalToCopy = originalToCopyArg;
        if (originalToCopy == null) {
            originalToCopy = new HashMap();
        }
        while (!jobQueue.isEmpty()) {
            CompositeNode jobNode = (CompositeNode)jobQueue.peek();
            if (!originalToCopy.isEmpty() && originalToCopy.keySet().containsAll(jobNode.getChildren())) {
                jobQueue.pop();
                List<Node<?>> newChildren = NodeUtils.collectMapValues(jobNode.getChildren(), originalToCopy);
                CompositeNode nodeCopy = NodeFactory.createImmutableCompositeNode(jobNode.getNodeType(), null, newChildren, jobNode.getModificationAction());
                NodeUtils.fixChildrenRelation(nodeCopy);
                originalToCopy.put((Node<?>)jobNode, (Node<?>)nodeCopy);
                continue;
            }
            for (Node child : jobNode.getChildren()) {
                if (child instanceof SimpleNode) {
                    originalToCopy.put((Node<?>)child, (Node<?>)NodeFactory.createImmutableSimpleNode(child.getNodeType(), null, child.getValue(), ((NodeModification)child).getModificationAction()));
                    continue;
                }
                if (!(child instanceof CompositeNode)) continue;
                jobQueue.push((CompositeNode)child);
            }
        }
        return (CompositeNode)originalToCopy.get(node);
    }
}

