/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.AbstractNodeTO;
import org.opendaylight.yangtools.yang.data.impl.NodeUtils;

public class MutableCompositeNodeTOImpl
extends AbstractNodeTO<List<Node<?>>>
implements MutableCompositeNode,
Serializable {
    private static final long serialVersionUID = 100L;
    private Map<QName, List<Node<?>>> nodeMap = new HashMap();
    private CompositeNode original;

    public MutableCompositeNodeTOImpl(QName qname, CompositeNode parent, List<Node<?>> value, ModifyAction modifyAction) {
        super(qname, parent, value, modifyAction);
        this.init();
    }

    public void init() {
        if (!this.getChildren().isEmpty()) {
            this.nodeMap = NodeUtils.buildNodeMap(this.getChildren());
        }
    }

    public List<Node<?>> getChildren() {
        return this.getValue() == null ? new ArrayList() : (List)this.getValue();
    }

    @Override
    public List<Node<?>> setValue(List<Node<?>> value) {
        List<Node<?>> oldVal = super.setValue(value);
        this.init();
        return oldVal;
    }

    public void setModifyAction(ModifyAction action) {
        super.setModificationAction(action);
    }

    protected Map<QName, List<Node<?>>> getNodeMap() {
        return this.nodeMap;
    }

    public MutableCompositeNode asMutable() {
        return this;
    }

    public CompositeNode getOriginal() {
        return this.original;
    }

    public void setOriginal(CompositeNode original) {
        this.original = original;
    }

    public SimpleNode<?> getFirstSimpleByName(QName leafQName) {
        List<SimpleNode<?>> list = this.getSimpleNodesByName(leafQName);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<CompositeNode> getCompositesByName(QName children) {
        List<Node<?>> toFilter = this.getNodeMap().get(children);
        if (toFilter == null) {
            return Collections.emptyList();
        }
        ArrayList<CompositeNode> list = new ArrayList<CompositeNode>();
        for (Node<?> node : toFilter) {
            if (!(node instanceof CompositeNode)) continue;
            list.add((CompositeNode)node);
        }
        return list;
    }

    public List<SimpleNode<?>> getSimpleNodesByName(QName children) {
        List<Node<?>> toFilter = this.getNodeMap().get(children);
        if (toFilter == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (Node<?> node : toFilter) {
            if (!(node instanceof SimpleNode)) continue;
            list.add((SimpleNode)node);
        }
        return list;
    }

    public CompositeNode getFirstCompositeByName(QName container) {
        List<CompositeNode> list = this.getCompositesByName(container);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public SimpleNode<?> getFirstLeafByName(QName leaf) {
        List<SimpleNode<?>> list = this.getSimpleNodesByName(leaf);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<CompositeNode> getCompositesByName(String children) {
        return this.getCompositesByName(new QName(this.getNodeType(), children));
    }

    public List<SimpleNode<?>> getSimpleNodesByName(String children) {
        return this.getSimpleNodesByName(new QName(this.getNodeType(), children));
    }

    @Override
    public String toString() {
        return super.toString() + ", children.size = " + (this.getChildren() != null ? Integer.valueOf(this.getChildren().size()) : "n/a");
    }

    public void clear() {
        this.nodeMap.clear();
    }

    public boolean containsKey(Object key) {
        return this.nodeMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.nodeMap.containsValue(value);
    }

    public Set<Map.Entry<QName, List<Node<?>>>> entrySet() {
        return this.nodeMap.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int size() {
        return this.nodeMap.size();
    }

    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    public List<Node<?>> get(Object key) {
        return this.nodeMap.get(key);
    }

    public List<Node<?>> put(QName key, List<Node<?>> value) {
        return this.nodeMap.put(key, value);
    }

    public List<Node<?>> remove(Object key) {
        return this.nodeMap.remove(key);
    }

    public void putAll(Map<? extends QName, ? extends List<Node<?>>> m) {
        this.nodeMap.putAll(m);
    }

    public Set<QName> keySet() {
        return this.nodeMap.keySet();
    }

    public Collection<List<Node<?>>> values() {
        return this.nodeMap.values();
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        QName qName = (QName)aStream.readObject();
        CompositeNode parent = (CompositeNode)aStream.readObject();
        List value = (List)aStream.readObject();
        ModifyAction modifyAction = (ModifyAction)aStream.readObject();
        this.init(qName, parent, value, modifyAction);
    }

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.defaultWriteObject();
        aStream.writeObject(this.getQName());
        aStream.writeObject(this.getParent());
        aStream.writeObject(this.getValue());
        aStream.writeObject(this.getModificationAction());
    }
}

