/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.NodeModification;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.impl.NodeFactory;

public class LazyNodeToNodeMap {
    private Map<Node<?>, Node<?>> node2node = new HashMap();
    private CompositeNode originalRoot;
    private MutableCompositeNode mutableRoot;

    public Node<?> getMutableEquivalent(Node<?> originalNode) {
        Node<?> mutableNode = this.node2node.get(originalNode);
        if (mutableNode == null) {
            this.addPathMembers(originalNode);
            mutableNode = this.node2node.get(originalNode);
        }
        return mutableNode;
    }

    private void addPathMembers(Node<?> originalNode) {
        Stack<Object> jobQueue = new Stack<Object>();
        jobQueue.push(originalNode);
        while (!jobQueue.isEmpty()) {
            Node node2add = (Node)jobQueue.pop();
            boolean fixChildrenRefOnly = false;
            if (this.node2node.containsKey(node2add)) {
                if (node2add instanceof SimpleNode) continue;
                fixChildrenRefOnly = true;
            }
            CompositeNode nextParent = node2add.getParent();
            MutableCompositeNode mutableEquivalent = null;
            if (node2add instanceof SimpleNode) {
                MutableCompositeNode nodeMutant;
                SimpleNode node2addSimple = (SimpleNode)node2add;
                mutableEquivalent = nodeMutant = NodeFactory.createMutableSimpleNode(node2add.getNodeType(), null, node2addSimple.getValue(), node2addSimple.getModificationAction(), node2addSimple);
            } else if (node2add instanceof CompositeNode) {
                MutableCompositeNode nodeMutant = null;
                if (fixChildrenRefOnly) {
                    nodeMutant = (MutableCompositeNode)this.node2node.get(node2add);
                } else {
                    CompositeNode node2addComposite = (CompositeNode)node2add;
                    nodeMutant = NodeFactory.createMutableCompositeNode(node2add.getNodeType(), null, null, ((NodeModification)node2add).getModificationAction(), node2addComposite);
                }
                mutableEquivalent = nodeMutant;
                if (nodeMutant.getChildren() == null) {
                    nodeMutant.setValue(new ArrayList());
                }
                for (Node originalChildNode : ((CompositeNode)node2add).getChildren()) {
                    MutableNode mutableChild = (MutableNode)this.node2node.get(originalChildNode);
                    LazyNodeToNodeMap.fixChildrenRef(nodeMutant, mutableChild);
                }
                if (nodeMutant.getChildren() != null && !nodeMutant.getChildren().isEmpty()) {
                    nodeMutant.init();
                }
                if (nextParent == null) {
                    if (this.originalRoot == null) {
                        this.originalRoot = (CompositeNode)node2add;
                        this.mutableRoot = nodeMutant;
                    } else if (!this.originalRoot.equals(node2add)) {
                        throw new IllegalStateException("Different tree root node obtained - perhaps nodes of different trees are getting mixed up.");
                    }
                }
            }
            this.node2node.put((Node<?>)node2add, (Node<?>)mutableEquivalent);
            if (nextParent == null) continue;
            jobQueue.push(nextParent);
        }
    }

    private static void fixChildrenRef(MutableCompositeNode nodeMutant, MutableNode<?> mutableChild) {
        if (mutableChild != null) {
            CompositeNode parentOfChild;
            if (!nodeMutant.getChildren().contains(mutableChild)) {
                nodeMutant.getChildren().add(mutableChild);
            }
            if ((parentOfChild = mutableChild.getParent()) == null) {
                mutableChild.setParent((CompositeNode)nodeMutant);
            } else if (!parentOfChild.equals(nodeMutant)) {
                throw new IllegalStateException("Different parent node obtained - perhaps nodes of different trees are getting mixed up.");
            }
        }
    }

    public MutableCompositeNode getMutableRoot() {
        return this.mutableRoot;
    }

    public Set<Node<?>> getKeyNodes() {
        return this.node2node.keySet();
    }
}

