/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.NodeModification;

public abstract class AbstractNodeTO<T>
implements Node<T>,
NodeModification {
    private QName qName;
    private CompositeNode parent;
    private T value;
    private ModifyAction modifyAction;

    public AbstractNodeTO() {
    }

    public AbstractNodeTO(QName qname, CompositeNode parent, T value) {
        this.qName = qname;
        this.parent = parent;
        this.value = value;
    }

    public AbstractNodeTO(QName qname, CompositeNode parent, T value, ModifyAction modifyAction) {
        this.qName = qname;
        this.parent = parent;
        this.value = value;
        this.modifyAction = modifyAction;
    }

    public QName getNodeType() {
        return this.qName;
    }

    public QName getQName() {
        return this.qName;
    }

    public CompositeNode getParent() {
        return this.parent;
    }

    public void setParent(CompositeNode parent) {
        this.parent = parent;
    }

    public T setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public T getValue() {
        return this.value;
    }

    public ModifyAction getModificationAction() {
        return this.modifyAction;
    }

    protected void setModificationAction(ModifyAction modifyAction) {
        this.modifyAction = modifyAction;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(String.format("Node[%s], qName[%s], modify[%s]", this.getClass().getSimpleName(), this.getQName().getLocalName(), this.getModificationAction() == null ? "n/a" : this.getModificationAction()));
        return out.toString();
    }

    public final QName getKey() {
        return this.getNodeType();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modifyAction == null ? 0 : this.modifyAction.hashCode());
        result = 31 * result + (this.qName == null ? 0 : this.qName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result % 2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeTO other = (AbstractNodeTO)obj;
        if (this.modifyAction != other.modifyAction) {
            return false;
        }
        if (this.parent == null ? other.parent != null : other.parent == null) {
            return false;
        }
        if (this.qName == null ? other.qName != null : !this.qName.equals((Object)other.qName)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    protected final void init(QName qName, CompositeNode parent, T value, ModifyAction modifyAction) {
        this.qName = qName;
        this.modifyAction = modifyAction;
        this.parent = parent;
        this.value = value;
    }
}

