/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topologymanager;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TopologyUserLinkConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TopologyUserLinkConfig.class);
    @XmlElement
    private String status;
    @XmlElement
    private String name;
    @XmlElement
    private String srcNodeConnector;
    @XmlElement
    private String dstNodeConnector;

    public TopologyUserLinkConfig() {
        this.status = STATUS.LINKDOWN.toString();
    }

    public TopologyUserLinkConfig(String name, String srcNodeConnector, String dstNodeConnector) {
        this.name = name;
        this.srcNodeConnector = srcNodeConnector;
        this.dstNodeConnector = dstNodeConnector;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public STATUS getStatus() {
        return STATUS.fromString(this.status);
    }

    public void setStatus(STATUS s) {
        this.status = s.toString();
    }

    public String getSrcNodeConnector() {
        return this.srcNodeConnector;
    }

    public void setSrcNodeConnector(String srcNodeConnector) {
        this.srcNodeConnector = srcNodeConnector;
    }

    public String getDstNodeConnector() {
        return this.dstNodeConnector;
    }

    public void setDstNodeConnector(String dstNodeConnector) {
        this.dstNodeConnector = dstNodeConnector;
    }

    public boolean isValidNodeConnector(String nodeConnectorStr) {
        return NodeConnector.fromString((String)nodeConnectorStr) != null;
    }

    public boolean isValid() {
        if (!this.isValidResourceName(this.name)) {
            logger.debug("Invalid name in user link: {}", (Object)this.name);
            return false;
        }
        if (!this.isValidNodeConnector(this.srcNodeConnector) || !this.isValidNodeConnector(this.dstNodeConnector)) {
            logger.debug("Invalid NodeConnector in user link: {}", (Object)this.name);
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dstNodeConnector == null ? 0 : this.dstNodeConnector.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.srcNodeConnector == null ? 0 : this.srcNodeConnector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopologyUserLinkConfig other = (TopologyUserLinkConfig)obj;
        if (this.dstNodeConnector == null ? other.dstNodeConnector != null : !this.dstNodeConnector.equals(other.dstNodeConnector)) {
            return false;
        }
        return !(this.srcNodeConnector == null ? other.srcNodeConnector != null : !this.srcNodeConnector.equals(other.srcNodeConnector));
    }

    public String toString() {
        return "TopologyUserLinkConfig [status=" + this.status + ", name=" + this.name + ", srcNodeConnector=" + this.srcNodeConnector + ", dstNodeConnector=" + this.dstNodeConnector + "]";
    }

    public static enum STATUS {
        SUCCESS("Success"),
        LINKDOWN("Link Down"),
        INCORRECT("Incorrect Connection");

        private String name;

        private STATUS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static STATUS fromString(String str) {
            if (str == null) {
                return LINKDOWN;
            }
            if (str.equals(SUCCESS.toString())) {
                return SUCCESS;
            }
            if (str.equals(LINKDOWN.toString())) {
                return LINKDOWN;
            }
            if (str.equals(INCORRECT.toString())) {
                return INCORRECT;
            }
            return LINKDOWN;
        }
    }
}

