/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts.util;

import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

public class ListenerRegistry<T extends EventListener>
implements Iterable<ListenerRegistration<T>> {
    private final ConcurrentHashMap<ListenerRegistration<? extends T>, ListenerRegistration<? extends T>> listeners = new ConcurrentHashMap();
    final Set<ListenerRegistration<T>> unmodifiableView;

    public ListenerRegistry() {
        Set rawSet = Collections.unmodifiableSet(this.listeners.keySet());
        this.unmodifiableView = rawSet;
    }

    public Iterable<ListenerRegistration<T>> getListeners() {
        return this.unmodifiableView;
    }

    public ListenerRegistration<T> register(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener should not be null.");
        }
        ListenerRegistrationImpl ret = new ListenerRegistrationImpl(this, listener);
        this.listeners.put(ret, ret);
        return ret;
    }

    public <L extends T> ListenerRegistration<L> registerWithType(L listener) {
        ListenerRegistrationImpl ret = new ListenerRegistrationImpl(this, listener);
        this.listeners.put(ret, ret);
        return ret;
    }

    @Override
    public Iterator<ListenerRegistration<T>> iterator() {
        return this.unmodifiableView.iterator();
    }

    private void remove(ListenerRegistrationImpl registration) {
        this.listeners.remove(registration);
    }

    public static <T extends EventListener> ListenerRegistry<T> create() {
        return new ListenerRegistry<T>();
    }

    private static class ListenerRegistrationImpl<P extends EventListener>
    extends AbstractObjectRegistration<P>
    implements ListenerRegistration<P> {
        final /* synthetic */ ListenerRegistry this$0;

        public ListenerRegistrationImpl(P instance) {
            this.this$0 = var1_1;
            super(instance);
        }

        @Override
        protected void removeRegistration() {
            this.this$0.remove(this);
        }
    }
}

