/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;

public class Immutables {
    public static final Set<Class<?>> KNOWN_IMMUTABLES = Immutables.asHashSet(Integer.class, Short.class, BigDecimal.class, BigInteger.class, Byte.class, Character.class, Double.class, Float.class);

    private Immutables() {
        throw new UnsupportedOperationException("Helper class");
    }

    public static boolean isImmutable(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object should not be null");
        }
        if (o instanceof Mutable) {
            return false;
        }
        if (o instanceof Immutable) {
            return true;
        }
        if (o instanceof String) {
            return true;
        }
        return KNOWN_IMMUTABLES.contains(o.getClass());
    }

    private static boolean isNumberImmutable(Number o) {
        if (o instanceof AtomicInteger) {
            return false;
        }
        if (o instanceof AtomicLong) {
            return false;
        }
        return o instanceof Short;
    }

    @SafeVarargs
    private static <E> Set<E> asHashSet(E ... list) {
        HashSet<E> ret = new HashSet<E>();
        for (E e : list) {
            ret.add(e);
        }
        return Collections.unmodifiableSet(ret);
    }
}

