/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <V> V withClassLoader(ClassLoader cls, Callable<V> function) throws Exception {
        return ClassLoaderUtils.withClassLoaderAndLock(cls, null, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withClassLoaderAndLock(ClassLoader cls, Lock lock, Callable<V> function) throws Exception {
        if (cls == null) {
            throw new IllegalArgumentException("Classloader should not be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("Function should not be null");
        }
        if (lock != null) {
            lock.lock();
        }
        ClassLoader oldCls = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cls);
            V v = function.call();
            return v;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCls);
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public static ParameterizedType findParameterizedType(Class<?> subclass, Class<?> genericType) {
        if (subclass == null || genericType == null) {
            throw new IllegalArgumentException("Class was not specified.");
        }
        for (Type type : subclass.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || !genericType.equals(((ParameterizedType)type).getRawType())) continue;
            return (ParameterizedType)type;
        }
        return null;
    }

    public static <S, G, P> Class<P> findFirstGenericArgument(Class<S> scannedClass, Class<G> genericType) {
        try {
            return ClassLoaderUtils.withClassLoader(scannedClass.getClassLoader(), ClassLoaderUtils.findFirstGenericArgumentTask(scannedClass, genericType));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <S, G, P> Callable<Class<P>> findFirstGenericArgumentTask(final Class<S> scannedClass, final Class<G> genericType) {
        return new Callable<Class<P>>(){

            @Override
            public Class<P> call() throws Exception {
                ParameterizedType augmentationGeneric = ClassLoaderUtils.findParameterizedType(scannedClass, genericType);
                if (augmentationGeneric == null) {
                    return null;
                }
                return (Class)augmentationGeneric.getActualTypeArguments()[0];
            }
        };
    }

    public static Type getFirstGenericParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }
}

