/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Registration;

public final class CompositeObjectRegistration<T>
extends AbstractObjectRegistration<T> {
    private final Set<Registration<? super T>> registrations;

    public CompositeObjectRegistration(T instance, Collection<? extends Registration<? super T>> registrations) {
        super(instance);
        if (registrations == null) {
            throw new IllegalArgumentException();
        }
        this.registrations = Collections.unmodifiableSet(new HashSet<Registration<? super T>>(registrations));
    }

    @Override
    protected void removeRegistration() {
        for (Registration<T> registration : this.registrations) {
            try {
                registration.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> CompositeObjectRegistrationBuilder<T> builderFor(T instance) {
        return new CompositeObjectRegistrationBuilder<T>(instance);
    }

    public static final class CompositeObjectRegistrationBuilder<T>
    implements Builder<CompositeObjectRegistration<T>> {
        private final T instance;
        private final Set<Registration<? super T>> registrations;

        public CompositeObjectRegistrationBuilder(T instance) {
            this.instance = instance;
            this.registrations = new HashSet<Registration<? super T>>();
        }

        public CompositeObjectRegistrationBuilder<T> add(Registration<? super T> registration) {
            if (registration.getInstance() != this.instance) {
                throw new IllegalArgumentException("Instance must be same.");
            }
            this.registrations.add(registration);
            return this;
        }

        public CompositeObjectRegistrationBuilder<T> remove(Registration<? super T> registration) {
            if (registration.getInstance() != this.instance) {
                throw new IllegalArgumentException("Instance must be same.");
            }
            this.registrations.remove(registration);
            return this;
        }

        @Override
        public CompositeObjectRegistration<T> toInstance() {
            return new CompositeObjectRegistration<T>(this.instance, this.registrations);
        }
    }
}

