/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import zmq.Command;
import zmq.Ctx;
import zmq.IPollEvents;
import zmq.Mailbox;
import zmq.Poller;
import zmq.SocketBase;
import zmq.ZObject;

public class Reaper
extends ZObject
implements IPollEvents {
    private final Mailbox mailbox;
    private SelectableChannel mailbox_handle;
    private final Poller poller;
    private int sockets = 0;
    private volatile boolean terminating = false;
    private String name;

    public Reaper(Ctx ctx_, int tid_) {
        super(ctx_, tid_);
        this.name = "reaper-" + tid_;
        this.poller = new Poller(this.name);
        this.mailbox = new Mailbox(this.name);
        this.mailbox_handle = this.mailbox.get_fd();
        this.poller.add_fd(this.mailbox_handle, this);
        this.poller.set_pollin(this.mailbox_handle);
    }

    public void destroy() {
        this.poller.destroy();
        this.mailbox.close();
    }

    public Mailbox get_mailbox() {
        return this.mailbox;
    }

    public void start() {
        this.poller.start();
    }

    public void stop() {
        if (!this.terminating) {
            this.send_stop();
        }
    }

    @Override
    public void in_event() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.destination().process_command(cmd);
        }
    }

    @Override
    public void out_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timer_event(int id_) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void process_stop() {
        this.terminating = true;
        if (this.sockets == 0) {
            this.send_done();
            this.poller.rm_fd(this.mailbox_handle);
            this.poller.stop();
        }
    }

    @Override
    protected void process_reap(SocketBase socket_) {
        socket_.start_reaping(this.poller);
        ++this.sockets;
    }

    @Override
    protected void process_reaped() {
        --this.sockets;
        if (this.sockets == 0 && this.terminating) {
            this.send_done();
            this.poller.rm_fd(this.mailbox_handle);
            this.poller.stop();
        }
    }
}

