/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Options;
import zmq.ZObject;

public abstract class Own
extends ZObject {
    protected final Options options;
    private boolean terminating;
    private final AtomicLong sent_seqnum;
    private long processed_seqnum;
    private Own owner;
    private final Set<Own> owned;
    private int term_acks;

    public Own(Ctx parent_, int tid_) {
        super(parent_, tid_);
        this.terminating = false;
        this.sent_seqnum = new AtomicLong(0L);
        this.processed_seqnum = 0L;
        this.owner = null;
        this.term_acks = 0;
        this.options = new Options();
        this.owned = new HashSet<Own>();
    }

    public Own(IOThread io_thread_, Options options_) {
        super(io_thread_);
        this.options = options_;
        this.terminating = false;
        this.sent_seqnum = new AtomicLong(0L);
        this.processed_seqnum = 0L;
        this.owner = null;
        this.term_acks = 0;
        this.owned = new HashSet<Own>();
    }

    public abstract void destroy();

    protected void process_destroy() {
        this.destroy();
    }

    private void set_owner(Own owner_) {
        assert (this.owner == null);
        this.owner = owner_;
    }

    public void inc_seqnum() {
        this.sent_seqnum.incrementAndGet();
    }

    @Override
    protected void process_seqnum() {
        ++this.processed_seqnum;
        this.check_term_acks();
    }

    protected void launch_child(Own object_) {
        object_.set_owner(this);
        this.send_plug(object_);
        this.send_own(this, object_);
    }

    protected void term_child(Own object_) {
        this.process_term_req(object_);
    }

    @Override
    protected void process_term_req(Own object_) {
        if (this.terminating) {
            return;
        }
        if (!this.owned.contains(object_)) {
            return;
        }
        this.owned.remove(object_);
        this.register_term_acks(1);
        this.send_term(object_, this.options.linger);
    }

    @Override
    protected void process_own(Own object_) {
        if (this.terminating) {
            this.register_term_acks(1);
            this.send_term(object_, 0);
            return;
        }
        this.owned.add(object_);
    }

    protected void terminate() {
        if (this.terminating) {
            return;
        }
        if (this.owner == null) {
            this.process_term(this.options.linger);
            return;
        }
        this.send_term_req(this.owner, this);
    }

    protected boolean is_terminating() {
        return this.terminating;
    }

    @Override
    protected void process_term(int linger_) {
        assert (!this.terminating);
        for (Own it : this.owned) {
            this.send_term(it, linger_);
        }
        this.register_term_acks(this.owned.size());
        this.owned.clear();
        this.terminating = true;
        this.check_term_acks();
    }

    public void register_term_acks(int count_) {
        this.term_acks += count_;
    }

    public void unregister_term_ack() {
        assert (this.term_acks > 0);
        --this.term_acks;
        this.check_term_acks();
    }

    @Override
    protected void process_term_ack() {
        this.unregister_term_ack();
    }

    private void check_term_acks() {
        if (this.terminating && this.processed_seqnum == this.sent_seqnum.get() && this.term_acks == 0) {
            assert (this.owned.isEmpty());
            if (this.owner != null) {
                this.send_term_ack(this.owner);
            }
            this.process_destroy();
        }
    }
}

