/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.Arrays;
import zmq.ZMQ;

public class Msg {
    public static final int more = 1;
    public static final int identity = 64;
    public static final int shared = 128;
    private static final byte type_min = 101;
    private static final byte type_vsm = 102;
    private static final byte type_lmsg = 103;
    private static final byte type_delimiter = 104;
    private static final byte type_max = 105;
    private byte type;
    private int flags;
    private int size;
    private byte[] data;
    private ByteBuffer buf;

    public Msg() {
        this.init((byte)102);
        this.size(0);
    }

    public Msg(boolean buffered) {
        if (buffered) {
            this.init((byte)103);
        } else {
            this.init((byte)102);
        }
    }

    public Msg(int size) {
        this.init((byte)102);
        this.size(size);
    }

    public Msg(int size, boolean buffered) {
        if (buffered) {
            this.init((byte)103);
        } else {
            this.init((byte)102);
        }
        this.size(size);
    }

    public Msg(Msg m) {
        this.clone(m);
    }

    public Msg(byte[] src) {
        this(src, false);
    }

    public Msg(String src) {
        this(src.getBytes(ZMQ.CHARSET), false);
    }

    public Msg(byte[] src, boolean copy) {
        this();
        if (src != null) {
            this.size = src.length;
            this.data = copy ? Arrays.copyOf(src, src.length) : src;
        }
    }

    public Msg(ByteBuffer src) {
        this.init((byte)103);
        this.buf = src.duplicate();
        this.buf.rewind();
        this.size = this.buf.remaining();
    }

    public final boolean is_identity() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean is_delimiter() {
        return this.type == 104;
    }

    public final boolean check() {
        return this.type >= 101 && this.type <= 105;
    }

    protected final void init(byte type_) {
        this.type = type_;
        this.flags = 0;
        this.size = -1;
        this.data = null;
        this.buf = null;
    }

    private final void size(int size_) {
        this.size = size_;
        if (this.type == 103) {
            this.flags = 0;
            this.buf = ByteBuffer.allocate(size_);
            this.data = null;
        } else {
            this.flags = 0;
            this.data = new byte[size_];
            this.buf = null;
        }
    }

    public final int flags() {
        return this.flags;
    }

    public final boolean has_more() {
        return (this.flags & 1) > 0;
    }

    public final byte type() {
        return this.type;
    }

    public final void set_flags(int flags_) {
        this.flags |= flags_;
    }

    public final void init_delimiter() {
        this.type = (byte)104;
        this.flags = 0;
    }

    public final byte[] data() {
        if (this.data == null && this.type == 103) {
            if (this.buf.isDirect()) {
                this.data = new byte[this.size];
                int pos = this.buf.position();
                this.buf.get(this.data);
                this.buf.position(pos);
            } else if (this.buf.arrayOffset() == 0) {
                this.data = this.buf.array();
            } else {
                this.data = new byte[this.size];
                System.arraycopy(this.buf.array(), this.buf.arrayOffset(), this.data, 0, this.size);
            }
        }
        return this.data;
    }

    public final ByteBuffer buf() {
        if (this.buf == null && this.type != 103) {
            this.buf = ByteBuffer.wrap(this.data);
        }
        return this.buf;
    }

    public final int size() {
        return this.size;
    }

    public final void close() {
        if (!this.check()) {
            throw new IllegalStateException();
        }
        this.init((byte)102);
    }

    public String toString() {
        return super.toString() + "[" + this.type + "," + this.size + "," + this.flags + "]";
    }

    private void clone(Msg m) {
        this.type = m.type;
        this.flags = m.flags;
        this.size = m.size;
        this.buf = m.buf;
        this.data = m.data;
    }

    public final void reset_flags(int f) {
        this.flags &= ~f;
    }

    public final void put(byte[] src, int i) {
        if (src == null) {
            return;
        }
        System.arraycopy(src, 0, this.data, i, src.length);
    }

    public final void put(byte[] src, int i, int len_) {
        if (len_ == 0 || src == null) {
            return;
        }
        System.arraycopy(src, 0, this.data, i, len_);
    }

    public final boolean is_vsm() {
        return this.type == 102;
    }

    public final void put(byte b) {
        this.data[0] = b;
    }

    public final void put(byte b, int i) {
        this.data[i] = b;
    }

    public final void put(String str, int i) {
        this.put(str.getBytes(ZMQ.CHARSET), i);
    }

    public final void put(Msg data, int i) {
        this.put(data.data, i);
    }
}

