/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.List;
import zmq.Msg;
import zmq.Pipe;
import zmq.Utils;

public class Dist {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int matching = 0;
    private int active = 0;
    private int eligible = 0;
    private boolean more = false;

    public void attach(Pipe pipe_) {
        if (this.more) {
            this.pipes.add(pipe_);
            Utils.swap(this.pipes, this.eligible, this.pipes.size() - 1);
            ++this.eligible;
        } else {
            this.pipes.add(pipe_);
            Utils.swap(this.pipes, this.active, this.pipes.size() - 1);
            ++this.active;
            ++this.eligible;
        }
    }

    public void match(Pipe pipe_) {
        int idx = this.pipes.indexOf(pipe_);
        if (idx < this.matching) {
            return;
        }
        if (idx >= this.eligible) {
            return;
        }
        Utils.swap(this.pipes, idx, this.matching);
        ++this.matching;
    }

    public void unmatch() {
        this.matching = 0;
    }

    public void terminated(Pipe pipe_) {
        if (this.pipes.indexOf(pipe_) < this.matching) {
            Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.matching - 1);
            --this.matching;
        }
        if (this.pipes.indexOf(pipe_) < this.active) {
            Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.active - 1);
            --this.active;
        }
        if (this.pipes.indexOf(pipe_) < this.eligible) {
            Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.eligible - 1);
            --this.eligible;
        }
        this.pipes.remove(pipe_);
    }

    public void activated(Pipe pipe_) {
        Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.eligible);
        ++this.eligible;
        if (!this.more) {
            Utils.swap(this.pipes, this.eligible - 1, this.active);
            ++this.active;
        }
    }

    public boolean send_to_all(Msg msg_) {
        this.matching = this.active;
        return this.send_to_matching(msg_);
    }

    public boolean send_to_matching(Msg msg_) {
        boolean msg_more = msg_.has_more();
        this.distribute(msg_);
        if (!msg_more) {
            this.active = this.eligible;
        }
        this.more = msg_more;
        return true;
    }

    private void distribute(Msg msg_) {
        if (this.matching == 0) {
            return;
        }
        for (int i = 0; i < this.matching; ++i) {
            if (this.write(this.pipes.get(i), msg_)) continue;
            --i;
        }
    }

    public boolean has_out() {
        return true;
    }

    private boolean write(Pipe pipe_, Msg msg_) {
        if (!pipe_.write(msg_)) {
            Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.matching - 1);
            --this.matching;
            Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.active - 1);
            --this.active;
            Utils.swap(this.pipes, this.active, this.eligible - 1);
            --this.eligible;
            return false;
        }
        if (!msg_.has_more()) {
            pipe_.flush();
        }
        return true;
    }
}

