/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.IMsgSink;
import zmq.Msg;

public class Decoder
extends DecoderBase {
    private static final int one_byte_size_ready = 0;
    private static final int eight_byte_size_ready = 1;
    private static final int flags_ready = 2;
    private static final int message_ready = 3;
    private final byte[] tmpbuf;
    private Msg in_progress;
    private final long maxmsgsize;
    private IMsgSink msg_sink;

    public Decoder(int bufsize_, long maxmsgsize_) {
        super(bufsize_);
        this.maxmsgsize = maxmsgsize_;
        this.tmpbuf = new byte[8];
        this.next_step(this.tmpbuf, 1, 0);
    }

    @Override
    public void set_msg_sink(IMsgSink msg_sink_) {
        this.msg_sink = msg_sink_;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.one_byte_size_ready();
            }
            case 1: {
                return this.eight_byte_size_ready();
            }
            case 2: {
                return this.flags_ready();
            }
            case 3: {
                return this.message_ready();
            }
        }
        return false;
    }

    private boolean one_byte_size_ready() {
        int first = this.tmpbuf[0];
        if (first == -1) {
            this.next_step(this.tmpbuf, 8, 1);
        } else {
            if (first == 0) {
                this.decoding_error();
                return false;
            }
            int size = first;
            if (size < 0) {
                size = 0xFF & first;
            }
            if (this.maxmsgsize >= 0L && (long)(size - 1) > this.maxmsgsize) {
                this.decoding_error();
                return false;
            }
            this.in_progress = new Msg(size - 1);
            this.next_step(this.tmpbuf, 1, 2);
        }
        return true;
    }

    private boolean eight_byte_size_ready() {
        long payload_length = ByteBuffer.wrap(this.tmpbuf).getLong();
        if (payload_length == 0L) {
            this.decoding_error();
            return false;
        }
        if (this.maxmsgsize >= 0L && payload_length - 1L > this.maxmsgsize) {
            this.decoding_error();
            return false;
        }
        if (payload_length - 1L > Integer.MAX_VALUE) {
            this.decoding_error();
            return false;
        }
        int msg_size = (int)(payload_length - 1L);
        this.in_progress = new Msg(msg_size);
        this.next_step(this.tmpbuf, 1, 2);
        return true;
    }

    private boolean flags_ready() {
        byte first = this.tmpbuf[0];
        this.in_progress.set_flags(first & 1);
        this.next_step(this.in_progress, 3);
        return true;
    }

    private boolean message_ready() {
        if (this.msg_sink == null) {
            return false;
        }
        int rc = this.msg_sink.push_msg(this.in_progress);
        if (rc != 0) {
            return false;
        }
        this.next_step(this.tmpbuf, 1, 0);
        return true;
    }
}

