/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.jeromq.ZMQ;

public class ZFrame {
    public static final int MORE = 1;
    public static final int REUSE = 2;
    public static final int DONTWAIT = 4;
    private boolean more;
    private byte[] data;

    protected ZFrame() {
    }

    public ZFrame(byte[] data) {
        if (data != null) {
            this.data = data;
        }
    }

    public ZFrame(String data) {
        if (data != null) {
            this.data = data.getBytes(ZMQ.CHARSET);
        }
    }

    public void destroy() {
        if (this.hasData()) {
            this.data = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] data() {
        return this.data;
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        if (this.hasData()) {
            return this.data.length;
        }
        return 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean send(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must be set");
        }
        int snd_flags = (flags & 1) > 0 ? 2 : 0;
        snd_flags |= (flags & 4) > 0 ? 1 : 0;
        return socket.send(this.data, snd_flags |= flags == 2 ? 2 : 0);
    }

    public boolean sendAndKeep(ZMQ.Socket socket, int flags) {
        return this.send(socket, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket) {
        return this.sendAndKeep(socket, 0);
    }

    public boolean sendAndDestroy(ZMQ.Socket socket, int flags) {
        boolean ret = this.send(socket, flags);
        if (ret) {
            this.destroy();
        }
        return ret;
    }

    public boolean sendAndDestroy(ZMQ.Socket socket) {
        return this.sendAndDestroy(socket, 0);
    }

    public ZFrame duplicate() {
        return new ZFrame(this.data);
    }

    public boolean hasSameData(ZFrame other) {
        if (other == null) {
            return false;
        }
        if (this.size() == other.size()) {
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public void reset(String data) {
        this.data = data.getBytes(ZMQ.CHARSET);
    }

    public void reset(byte[] data) {
        this.data = data;
    }

    public String strhex() {
        String hexChar = "0123456789ABCDEF";
        StringBuilder b = new StringBuilder();
        for (int nbr = 0; nbr < this.data.length; ++nbr) {
            int b1 = this.data[nbr] >>> 4 & 0xF;
            int b2 = this.data[nbr] & 0xF;
            b.append(hexChar.charAt(b1));
            b.append(hexChar.charAt(b2));
        }
        return b.toString();
    }

    public boolean streq(String str) {
        if (!this.hasData()) {
            return false;
        }
        return new String(this.data, ZMQ.CHARSET).compareTo(str) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)o;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        return this.data != null ? Arrays.hashCode(this.data) : 0;
    }

    public String toString() {
        if (!this.hasData()) {
            return null;
        }
        boolean isText = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] >= 32 && this.data[i] <= 127) continue;
            isText = false;
        }
        if (isText) {
            return new String(this.data, ZMQ.CHARSET);
        }
        return this.strhex();
    }

    private byte[] recv(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must not be null");
        }
        this.data = socket.recv(flags);
        this.more = socket.hasReceiveMore();
        return this.data;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        ZFrame f = new ZFrame();
        f.recv(socket, 0);
        return f;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int flags) {
        ZFrame f = new ZFrame();
        f.recv(socket, flags);
        return f;
    }

    public void print(String prefix) {
        int char_nbr;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (prefix != null) {
            pw.printf("%s", prefix);
        }
        byte[] data = this.getData();
        int size = this.size();
        boolean is_bin = false;
        for (char_nbr = 0; char_nbr < size; ++char_nbr) {
            if (data[char_nbr] >= 9 && data[char_nbr] <= 127) continue;
            is_bin = true;
        }
        pw.printf("[%03d] ", size);
        int max_size = is_bin ? 35 : 70;
        String elipsis = "";
        if (size > max_size) {
            size = max_size;
            elipsis = "...";
        }
        for (char_nbr = 0; char_nbr < size; ++char_nbr) {
            if (is_bin) {
                pw.printf("%02X", data[char_nbr]);
                continue;
            }
            pw.printf("%c", data[char_nbr]);
        }
        pw.printf("%s\n", elipsis);
        pw.flush();
        pw.close();
        try {
            sw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.print(sw.toString());
    }
}

