/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.appauth.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.sal.authorization.AppRoleLevel;
import org.opendaylight.controller.sal.authorization.IResourceAuthorization;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.Resource;
import org.opendaylight.controller.sal.authorization.ResourceGroup;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.usermanager.IUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Authorization<T>
implements IResourceAuthorization {
    private static final Logger logger = LoggerFactory.getLogger(Authorization.class);
    private static final String namesRegex = "^[a-zA-Z0-9]+[{\\.|\\_|\\-}[a-zA-Z0-9]]*$";
    protected ConcurrentMap<String, Set<T>> resourceGroups;
    protected ConcurrentMap<String, AppRoleLevel> roles;
    protected ConcurrentMap<String, Set<ResourceGroup>> groupsAuthorizations;
    protected String allResourcesGroupName;

    public Status createRole(String role, AppRoleLevel level) {
        if (role == null || role.trim().isEmpty() || !role.matches(namesRegex)) {
            return new Status(StatusCode.BADREQUEST, "Role name must start with alphanumeric, no special characters.");
        }
        if (this.isControllerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "Controller roles cannot be explicitely created in App context");
        }
        if (this.isContainerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "Container roles cannot be explicitely created in App context");
        }
        if (this.isRoleInUse(role)) {
            return new Status(StatusCode.CONFLICT, "Role already in use");
        }
        if (this.roles.containsKey(role)) {
            if (((AppRoleLevel)this.roles.get(role)).equals((Object)level)) {
                return new Status(StatusCode.SUCCESS, "Role is already present");
            }
            return new Status(StatusCode.BADREQUEST, "Role exists and has different level");
        }
        return this.createRoleInternal(role, level);
    }

    protected Status createRoleInternal(String role, AppRoleLevel level) {
        this.roles.put(role, level);
        this.groupsAuthorizations.put(role, new HashSet());
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeRole(String role) {
        if (role == null || role.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Role name can't be empty");
        }
        if (this.isControllerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "Controller roles cannot be removed");
        }
        if (this.isContainerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "Container roles cannot be removed");
        }
        return this.removeRoleInternal(role);
    }

    protected Status removeRoleInternal(String role) {
        this.groupsAuthorizations.remove(role);
        this.roles.remove(role);
        return new Status(StatusCode.SUCCESS);
    }

    public List<String> getRoles() {
        return new ArrayList<String>(this.groupsAuthorizations.keySet());
    }

    public Status createResourceGroup(String groupName, List<Object> resources) {
        if (groupName == null || groupName.trim().isEmpty() || !groupName.matches(namesRegex)) {
            return new Status(StatusCode.BADREQUEST, "Group name must start with alphanumeric, no special characters");
        }
        if (groupName.equals(this.allResourcesGroupName)) {
            return new Status(StatusCode.NOTALLOWED, "All resource group cannot be created");
        }
        if (this.resourceGroups.containsKey(groupName)) {
            return new Status(StatusCode.CONFLICT, "Group name already exists");
        }
        HashSet<Object> toBeAdded = new HashSet<Object>();
        boolean allAdded = true;
        for (Object obj : resources) {
            try {
                toBeAdded.add(obj);
            }
            catch (ClassCastException e) {
                logger.debug("Attempt to add a resource with invalid type");
                allAdded = false;
            }
        }
        this.resourceGroups.put(groupName, toBeAdded);
        return allAdded ? new Status(StatusCode.SUCCESS, "All resources added succesfully") : new Status(StatusCode.SUCCESS, "One or more resources couldn't be added");
    }

    public Status addResourceToGroup(String groupName, Object resource) {
        if (groupName == null || groupName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        if (resource == null) {
            return new Status(StatusCode.BADREQUEST, "Null resource");
        }
        Object castedResource = null;
        try {
            castedResource = resource;
        }
        catch (ClassCastException e) {
            logger.debug("Attempt to add a resource with invalid type");
            return new Status(StatusCode.BADREQUEST, "Incompatible resource");
        }
        Set group = (Set)this.resourceGroups.get(groupName);
        if (group == null) {
            return new Status(StatusCode.NOTFOUND, "Group not found");
        }
        return this.addResourceToGroupInternal(groupName, castedResource);
    }

    protected Status addResourceToGroupInternal(String groupName, T resource) {
        Set group = (Set)this.resourceGroups.get(groupName);
        group.add(resource);
        this.resourceGroups.put(groupName, group);
        return new Status(StatusCode.SUCCESS, "Resource added successfully");
    }

    private Status removeRoleResourceGroupMapping(String groupName) {
        ArrayList<String> affectedRoles = new ArrayList<String>();
        block0: for (Map.Entry pairs : this.groupsAuthorizations.entrySet()) {
            String role = (String)pairs.getKey();
            Set groups = (Set)pairs.getValue();
            for (ResourceGroup group : groups) {
                if (!group.getGroupName().equals(groupName)) continue;
                affectedRoles.add(role);
                continue block0;
            }
        }
        StringBuffer msg = new StringBuffer();
        for (String role : affectedRoles) {
            Status result = this.unassignResourceGroupFromRole(groupName, role);
            if (result.isSuccess()) continue;
            msg.append(result.getDescription());
            msg.append(' ');
        }
        if (msg.length() != 0) {
            return new Status(StatusCode.BADREQUEST, msg.toString());
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeResourceGroup(String groupName) {
        if (groupName == null || groupName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        if (groupName.equals(this.allResourcesGroupName)) {
            return new Status(StatusCode.NOTALLOWED, "All resource group cannot be removed");
        }
        this.resourceGroups.remove(groupName);
        Status result = this.removeRoleResourceGroupMapping(groupName);
        return result.isSuccess() ? result : new Status(StatusCode.SUCCESS, "Failed removing group from: " + result.getDescription());
    }

    public Status removeResourceFromGroup(String groupName, Object resource) {
        if (groupName == null || groupName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        Set group = (Set)this.resourceGroups.get(groupName);
        if (group != null && group.remove(resource)) {
            this.resourceGroups.put(groupName, group);
            return new Status(StatusCode.SUCCESS, "Resource removed successfully");
        }
        return new Status(StatusCode.NOTFOUND, "Group/Resource not found");
    }

    public UserLevel getUserLevel(String userName) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (logger.isDebugEnabled()) {
            logger.debug("User {} has UserLevel {}", (Object)userName, (Object)userManager.getUserLevel(userName));
        }
        return userManager == null ? UserLevel.NOUSER : userManager.getUserLevel(userName);
    }

    public Set<Resource> getAllResourcesforUser(String userName) {
        HashSet<Resource> resources = new HashSet<Resource>();
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return new HashSet<Resource>(0);
        }
        List roles = userManager.getUserRoles(userName);
        if (roles == null) {
            return resources;
        }
        for (String role : roles) {
            List<ResourceGroup> groups = this.getAuthorizedGroups(role);
            if (groups.isEmpty()) continue;
            for (ResourceGroup group : groups) {
                List<Object> list = this.getResources(group.getGroupName());
                if (list.isEmpty()) continue;
                for (Object resource : list) {
                    Resource toBeAdded = new Resource(resource, group.getPrivilege());
                    Resource existing = this.higherPrivilegeResourcePresent(resources, toBeAdded);
                    if (existing == null) {
                        resources.add(toBeAdded);
                    }
                    if ((existing = this.lowerPrivilegeResourcePresent(resources, toBeAdded)) == null) continue;
                    resources.remove(existing);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("User {} has resources {}", (Object)userName, resources);
        }
        return resources;
    }

    public List<Resource> getAuthorizedResources(String role) {
        HashSet<Resource> resources = new HashSet<Resource>();
        List<ResourceGroup> groups = this.getAuthorizedGroups(role);
        if (groups.isEmpty()) {
            return new ArrayList<Resource>(0);
        }
        for (ResourceGroup group : groups) {
            List<Object> list = this.getResources(group.getGroupName());
            if (list.isEmpty()) continue;
            for (Object resource : list) {
                Resource toBeAdded = new Resource(resource, group.getPrivilege());
                Resource existing = this.higherPrivilegeResourcePresent(resources, toBeAdded);
                if (existing == null) {
                    resources.add(toBeAdded);
                }
                if ((existing = this.lowerPrivilegeResourcePresent(resources, toBeAdded)) == null) continue;
                resources.remove(existing);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("For the Role {}, Authorized Resources are {}", (Object)role, resources);
        }
        return new ArrayList<Resource>(resources);
    }

    private Resource lowerPrivilegeResourcePresent(Set<Resource> resources, Resource resource) {
        if (resource == null || resources == null) {
            return null;
        }
        Object resourceElement = resource.getResource();
        Privilege resourcePrivilege = resource.getPrivilege();
        for (Resource element : resources) {
            if (!element.getResource().equals(resourceElement) || element.getPrivilege().ordinal() >= resourcePrivilege.ordinal()) continue;
            return element;
        }
        return null;
    }

    private Resource higherPrivilegeResourcePresent(Set<Resource> resources, Resource resource) {
        if (resource == null || resources == null) {
            return null;
        }
        Object resourceElement = resource.getResource();
        Privilege resourcePrivilege = resource.getPrivilege();
        for (Resource element : resources) {
            if (!element.getResource().equals(resourceElement) || element.getPrivilege().ordinal() <= resourcePrivilege.ordinal()) continue;
            return element;
        }
        return null;
    }

    public Privilege getResourcePrivilege(String userName, Object resource) {
        if (userName == null || userName.trim().isEmpty() || resource == null) {
            return Privilege.NONE;
        }
        Set<Resource> hisResources = this.getAllResourcesforUser(userName);
        for (Resource element : hisResources) {
            if (!element.getResource().equals(resource)) continue;
            return element.getPrivilege();
        }
        return Privilege.NONE;
    }

    public List<String> getResourceGroups() {
        return new ArrayList<String>(this.resourceGroups.keySet());
    }

    public Status assignResourceGroupToRole(String group, Privilege privilege, String role) {
        if (group == null || group.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        if (role == null || role.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Role name can't be empty");
        }
        if (this.isControllerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "No group assignment is accepted for Controller roles");
        }
        return this.assignResourceGroupToRoleInternal(group, privilege, role);
    }

    protected Status assignResourceGroupToRoleInternal(String group, Privilege privilege, String role) {
        Set roleGroups = (Set)this.groupsAuthorizations.get(role);
        roleGroups.add(new ResourceGroup(group, privilege));
        this.groupsAuthorizations.put(role, roleGroups);
        return new Status(StatusCode.SUCCESS);
    }

    public Status assignResourceGroupToRole(String groupName, String roleName) {
        if (groupName == null || groupName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Group name can't be empty");
        }
        if (roleName == null || roleName.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Role name can't be empty");
        }
        Privilege privilege = Privilege.NONE;
        switch (this.getApplicationRoleLevel(roleName)) {
            case APPADMIN: {
                privilege = Privilege.WRITE;
                break;
            }
            case APPUSER: {
                privilege = Privilege.USE;
                break;
            }
            case APPOPERATOR: {
                privilege = Privilege.READ;
                break;
            }
        }
        return this.assignResourceGroupToRole(groupName, privilege, roleName);
    }

    public Status unassignResourceGroupFromRole(String group, String role) {
        if (group == null || group.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Group name can't be empty");
        }
        if (role == null || role.trim().isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Role name can't be empty");
        }
        if (this.isControllerRole(role)) {
            return new Status(StatusCode.NOTALLOWED, "No group assignment change is allowed for Controller roles");
        }
        return this.unassignResourceGroupFromRoleInternal(group, role);
    }

    protected Status unassignResourceGroupFromRoleInternal(String group, String role) {
        ResourceGroup target = null;
        for (ResourceGroup rGroup : (Set)this.groupsAuthorizations.get(role)) {
            if (!rGroup.getGroupName().equals(group)) continue;
            target = rGroup;
            break;
        }
        if (target == null) {
            return new Status(StatusCode.SUCCESS, "Group " + group + " was not assigned to " + role);
        }
        Set groups = (Set)this.groupsAuthorizations.get(role);
        groups.remove(target);
        this.groupsAuthorizations.put(role, groups);
        return new Status(StatusCode.SUCCESS);
    }

    public List<ResourceGroup> getAuthorizedGroups(String role) {
        return this.groupsAuthorizations.containsKey(role) ? new ArrayList((Collection)this.groupsAuthorizations.get(role)) : new ArrayList();
    }

    public List<Object> getResources(String groupName) {
        return this.resourceGroups.containsKey(groupName) ? new ArrayList((Collection)this.resourceGroups.get(groupName)) : new ArrayList(0);
    }

    public boolean isApplicationRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        return this.roles.containsKey(roleName);
    }

    public boolean isApplicationUser(String userName) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return false;
        }
        List roles = userManager.getUserRoles(userName);
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                if (!this.isApplicationRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    public AppRoleLevel getApplicationRoleLevel(String roleName) {
        if (roleName == null || roleName.trim().isEmpty()) {
            return AppRoleLevel.NOUSER;
        }
        if (this.isControllerRole(roleName)) {
            if (roleName.equals(UserLevel.NETWORKADMIN.toString()) || roleName.equals(UserLevel.SYSTEMADMIN.toString())) {
                return AppRoleLevel.APPADMIN;
            }
            return AppRoleLevel.APPOPERATOR;
        }
        return this.roles.containsKey(roleName) ? (AppRoleLevel)this.roles.get(roleName) : AppRoleLevel.NOUSER;
    }

    public AppRoleLevel getUserApplicationLevel(String userName) {
        List roles = null;
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userName == null || userName.trim().isEmpty() || userManager == null || (roles = userManager.getUserRoles(userName)).isEmpty()) {
            return AppRoleLevel.NOUSER;
        }
        AppRoleLevel highestLevel = AppRoleLevel.NOUSER;
        for (String role : roles) {
            AppRoleLevel level = this.getApplicationRoleLevel(role);
            if (level.ordinal() >= highestLevel.ordinal()) continue;
            highestLevel = level;
        }
        return highestLevel;
    }

    public String getHighestUserRole(String user) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        String highestRole = "";
        if (userManager != null && !userManager.getUserRoles(user).isEmpty()) {
            List roles = userManager.getUserRoles(user);
            AppRoleLevel highestLevel = AppRoleLevel.NOUSER;
            for (String role : roles) {
                AppRoleLevel current;
                if (!this.isApplicationRole(role) || (current = this.getApplicationRoleLevel(role)).ordinal() >= highestLevel.ordinal()) continue;
                highestRole = role;
                highestLevel = current;
            }
        }
        return highestRole;
    }

    private boolean isControllerRole(String role) {
        return role.equals(UserLevel.NETWORKADMIN.toString()) || role.equals(UserLevel.SYSTEMADMIN.toString()) || role.equals(UserLevel.NETWORKOPERATOR.toString());
    }

    private boolean isContainerRole(String role) {
        IContainerAuthorization containerAuth = (IContainerAuthorization)ServiceHelper.getGlobalInstance(IContainerAuthorization.class, (Object)this);
        if (containerAuth == null) {
            return false;
        }
        return containerAuth.isApplicationRole(role);
    }

    private boolean isRoleInUse(String role) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return true;
        }
        return userManager.isRoleInUse(role);
    }
}

