/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="flow-spec-config")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ContainerFlowConfig
extends ConfigurationObject
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ContainerFlowConfig.class);
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String name;
    @XmlElement
    private String dlVlan;
    @XmlElement
    private String nwSrc;
    @XmlElement
    private String nwDst;
    @XmlElement
    private String protocol;
    @XmlElement
    private String tpSrc;
    @XmlElement
    private String tpDst;
    private static boolean unidirectional = false;

    public ContainerFlowConfig() {
    }

    public ContainerFlowConfig(String name, String srcIP, String dstIP, String proto, String srcPort, String dstPort) {
        this.name = name;
        this.dlVlan = null;
        this.nwSrc = srcIP;
        this.nwDst = dstIP;
        this.protocol = proto;
        this.tpSrc = srcPort;
        this.tpDst = dstPort;
    }

    public ContainerFlowConfig(String name, String dlVlan, String srcIP, String dstIP, String proto, String srcPort, String dstPort) {
        this.name = name;
        this.dlVlan = dlVlan;
        this.nwSrc = srcIP;
        this.nwDst = dstIP;
        this.protocol = proto;
        this.tpSrc = srcPort;
        this.tpDst = dstPort;
    }

    public ContainerFlowConfig(ContainerFlowConfig containerFlowConfig) {
        this.name = containerFlowConfig.name;
        this.dlVlan = containerFlowConfig.dlVlan;
        this.nwSrc = containerFlowConfig.nwSrc;
        this.nwDst = containerFlowConfig.nwDst;
        this.protocol = containerFlowConfig.protocol;
        this.tpSrc = containerFlowConfig.tpSrc;
        this.tpDst = containerFlowConfig.tpDst;
    }

    public String getName() {
        return this.name;
    }

    public String getVlan() {
        return this.dlVlan == null || this.dlVlan.isEmpty() ? null : this.dlVlan;
    }

    public String getSrcIP() {
        return this.nwSrc == null || this.nwSrc.isEmpty() ? null : this.nwSrc;
    }

    public String getDstIP() {
        return this.nwDst == null || this.nwDst.isEmpty() ? null : this.nwDst;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSrcPort() {
        return this.tpSrc == null || this.tpSrc.isEmpty() ? null : this.tpSrc;
    }

    public String getDstPort() {
        return this.tpDst == null || this.tpDst.isEmpty() ? null : this.tpDst;
    }

    public boolean isUnidirectional() {
        return unidirectional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.dlVlan == null ? 0 : this.dlVlan.hashCode());
        result = 31 * result + (this.nwDst == null ? 0 : this.nwDst.hashCode());
        result = 31 * result + (this.tpDst == null ? 0 : this.tpDst.hashCode());
        result = 31 * result + (this.nwSrc == null ? 0 : this.nwSrc.hashCode());
        result = 31 * result + (this.tpSrc == null ? 0 : this.tpSrc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerFlowConfig other = (ContainerFlowConfig)obj;
        return this.matchName(other) && this.matchDlVlan(other) && this.matchSrcIP(other) && this.matchDstIP(other) && this.matchProtocol(other) && this.matchSrcPort(other) && this.matchDstPort(other);
    }

    public boolean equalsByName(String name) {
        return this.name.equals(name);
    }

    public boolean equalsByMatch(ContainerFlowConfig that) {
        List<Match> thisMatch = this.getMatches();
        List<Match> otherMatch = that.getMatches();
        for (Match m1 : thisMatch) {
            for (Match m2 : otherMatch) {
                if (!m1.equals((Object)m2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchName(ContainerFlowConfig flowSpec) {
        if (this.name == flowSpec.name) {
            return true;
        }
        if (this.name == null || flowSpec.name == null) {
            return false;
        }
        return this.name.equals(flowSpec.name);
    }

    private boolean matchDlVlan(ContainerFlowConfig flowSpec) {
        if (this.dlVlan == flowSpec.dlVlan) {
            return true;
        }
        if (this.dlVlan == null || flowSpec.dlVlan == null) {
            return false;
        }
        return this.getVlanList().equals(flowSpec.getVlanList());
    }

    private boolean matchSrcIP(ContainerFlowConfig flowSpec) {
        if (this.nwSrc == flowSpec.nwSrc) {
            return true;
        }
        if (this.nwSrc == null || flowSpec.nwSrc == null) {
            return false;
        }
        return this.nwSrc.equals(flowSpec.nwSrc);
    }

    private boolean matchDstIP(ContainerFlowConfig flowSpec) {
        if (this.nwDst == flowSpec.nwDst) {
            return true;
        }
        if (this.nwDst == null || flowSpec.nwDst == null) {
            return false;
        }
        return this.nwDst.equals(flowSpec.nwDst);
    }

    private boolean matchProtocol(ContainerFlowConfig flowSpec) {
        if (this.protocol == flowSpec.protocol) {
            return true;
        }
        if (this.protocol == null || flowSpec.protocol == null) {
            return false;
        }
        return this.protocol.equals(flowSpec.protocol);
    }

    private boolean matchSrcPort(ContainerFlowConfig flowSpec) {
        if (this.tpSrc == flowSpec.tpSrc) {
            return true;
        }
        if (this.tpSrc == null || flowSpec.tpSrc == null) {
            return false;
        }
        return this.tpSrc.equals(flowSpec.tpSrc);
    }

    private boolean matchDstPort(ContainerFlowConfig flowSpec) {
        if (this.tpDst == flowSpec.tpDst) {
            return true;
        }
        if (this.tpDst == null || flowSpec.tpDst == null) {
            return false;
        }
        return this.tpDst.equals(flowSpec.tpDst);
    }

    public Set<Short> getVlanList() {
        HashSet<Short> vlanList = new HashSet<Short>();
        try {
            String[] elemArray;
            for (String elem : elemArray = this.dlVlan.split(",")) {
                if (elem.contains("-")) {
                    String[] limits = elem.split("-");
                    for (short j = Short.valueOf(limits[0]).shortValue(); j <= Short.valueOf(limits[1]); j = (short)(j + 1)) {
                        vlanList.add(j);
                    }
                    continue;
                }
                vlanList.add(Short.valueOf(elem));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return vlanList;
    }

    public Short getSrcIPMaskLen() {
        Short maskLen = 0;
        if (this.nwSrc != null && !this.nwSrc.isEmpty()) {
            String[] s = this.nwSrc.split("/");
            if (s.length == 2) {
                try {
                    maskLen = Short.valueOf(s[1]);
                }
                catch (Exception e) {}
            } else {
                InetAddress ip = this.getSrcIPNum();
                maskLen = (short)(ip instanceof Inet4Address ? 32 : 128);
            }
        }
        return maskLen;
    }

    public Short getDstIPMaskLen() {
        Short maskLen = 0;
        if (this.nwDst != null && !this.nwDst.isEmpty()) {
            String[] s = this.nwDst.split("/");
            if (s.length == 2) {
                try {
                    maskLen = Short.valueOf(s[1]);
                }
                catch (Exception e) {}
            } else {
                InetAddress ip = this.getDstIPNum();
                maskLen = (short)(ip instanceof Inet4Address ? 32 : 128);
            }
        }
        return maskLen;
    }

    public InetAddress getSrcIPNum() {
        InetAddress ip = null;
        if (this.nwSrc == null || this.nwSrc.isEmpty()) {
            try {
                ip = InetAddress.getByAddress(new byte[16]);
                return ip;
            }
            catch (UnknownHostException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        try {
            ip = InetAddress.getByName(this.nwSrc.split("/")[0]);
        }
        catch (UnknownHostException e1) {
            log.error("", (Throwable)e1);
            return null;
        }
        return ip;
    }

    public InetAddress getDstIPNum() {
        InetAddress ip = null;
        if (this.nwDst == null || this.nwDst.isEmpty()) {
            try {
                ip = InetAddress.getByAddress(new byte[16]);
                return ip;
            }
            catch (UnknownHostException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        try {
            ip = InetAddress.getByName(this.nwDst.split("/")[0]);
        }
        catch (UnknownHostException e1) {
            log.error("", (Throwable)e1);
            return null;
        }
        return ip;
    }

    public Short getSrcPortNum() {
        return this.tpSrc == null || this.tpSrc.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(this.tpSrc);
    }

    public Short getDstPortNum() {
        return this.tpDst == null || this.tpDst.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(this.tpDst);
    }

    public Short getProtoNum() {
        return this.protocol == null ? null : Short.valueOf(IPProtocols.getProtocolNumberShort((String)this.protocol));
    }

    public boolean overlap(ContainerFlowConfig other) {
        if (other == null) {
            return false;
        }
        List<Match> myMathes = this.getMatches();
        List<Match> hisMatches = other.getMatches();
        for (Match mine : myMathes) {
            for (Match his : hisMatches) {
                if (!mine.intersetcs(his)) continue;
                return true;
            }
        }
        return false;
    }

    public Status validate() {
        if (!this.isValidResourceName(this.name)) {
            return new Status(StatusCode.BADREQUEST, "Invalid name");
        }
        Status status = this.validateVlan();
        if (!status.isSuccess()) {
            return status;
        }
        status = this.validateIPs();
        if (!status.isSuccess()) {
            return status;
        }
        if (!this.hasValidProtocol()) {
            return new Status(StatusCode.BADREQUEST, "Invalid IP protocol");
        }
        if (!this.hasValidPorts()) {
            return new Status(StatusCode.BADREQUEST, "Invalid Source or Destination Port");
        }
        if (this.getMatches().get(0).getMatches() == 0) {
            return new Status(StatusCode.BADREQUEST, "Flow Spec is empty");
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateVlan() {
        if (this.dlVlan != null) {
            short vlanId = 0;
            try {
                String[] elemArray;
                for (String elem : elemArray = this.dlVlan.split(",")) {
                    String[] limits;
                    if (!(elem.contains("-") ? Short.parseShort((limits = elem.split("-"))[0]) < 0 || Short.parseShort(limits[0]) >= Short.parseShort(limits[1]) || Short.parseShort(limits[1]) > 4095 : (vlanId = Short.parseShort(elem)) < 0 || vlanId > 4095)) continue;
                    return new Status(StatusCode.BADREQUEST, "Invalid vlan id");
                }
            }
            catch (NumberFormatException e) {
                return new Status(StatusCode.BADREQUEST, "Invalid vlan id");
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateIPs() {
        long prefix;
        byte[] bytePrefix;
        if (this.nwSrc != null) {
            if (!NetUtils.isIPAddressValid((String)this.nwSrc)) {
                return new Status(StatusCode.BADREQUEST, "Invalid network source address");
            }
            bytePrefix = NetUtils.getSubnetPrefix((InetAddress)this.getSrcIPNum(), (int)this.getSrcIPMaskLen().shortValue()).getAddress();
            prefix = BitBufferHelper.getLong((byte[])bytePrefix);
            if (prefix == 0L) {
                return new Status(StatusCode.BADREQUEST, "Invalid network source address: subnet zero");
            }
        }
        if (this.nwDst != null) {
            if (!NetUtils.isIPAddressValid((String)this.nwDst)) {
                return new Status(StatusCode.BADREQUEST, "Invalid network destination address");
            }
            bytePrefix = NetUtils.getSubnetPrefix((InetAddress)this.getDstIPNum(), (int)this.getDstIPMaskLen().shortValue()).getAddress();
            prefix = BitBufferHelper.getLong((byte[])bytePrefix);
            if (prefix == 0L) {
                return new Status(StatusCode.BADREQUEST, "Invalid network destination address: subnet zero");
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private boolean hasValidProtocol() {
        IPProtocols p = IPProtocols.fromString((String)this.protocol);
        return p != null;
    }

    private boolean hasValidPort(String tpPort) {
        try {
            int port = Integer.decode(tpPort);
            return port >= 0 && port <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean hasValidPorts() {
        if (this.tpSrc != null && !this.tpSrc.isEmpty() && !this.hasValidPort(this.tpSrc)) {
            return false;
        }
        if (this.tpDst != null && !this.tpDst.isEmpty()) {
            return this.hasValidPort(this.tpDst);
        }
        return true;
    }

    public List<Match> getMatches() {
        ArrayList<Match> matches = new ArrayList<Match>();
        if (this.dlVlan != null && !this.dlVlan.isEmpty()) {
            for (Short vlan : this.getVlanList()) {
                Match match = this.getMatch(vlan);
                matches.add(match);
            }
        } else {
            Match match = this.getMatch(null);
            matches.add(match);
        }
        if (!unidirectional) {
            ArrayList<Match> forwardMatches = new ArrayList<Match>(matches);
            for (Match match : forwardMatches) {
                Match reverse;
                if (match.equals((Object)(reverse = match.reverse()))) continue;
                matches.add(reverse);
            }
        }
        return matches;
    }

    private Match getMatch(Short vlan) {
        int maskLen;
        InetAddress mask;
        InetAddress ip;
        String[] parts;
        Match match = new Match();
        if (vlan != null) {
            match.setField(MatchType.DL_VLAN, (Object)vlan);
        }
        if (this.nwSrc != null && !this.nwSrc.trim().isEmpty()) {
            parts = this.nwSrc.split("/");
            ip = NetUtils.parseInetAddress((String)parts[0]);
            mask = null;
            maskLen = 0;
            maskLen = parts.length > 1 ? Integer.parseInt(parts[1]) : (ip instanceof Inet6Address ? 128 : 32);
            mask = NetUtils.getInetNetworkMask((int)maskLen, (boolean)(ip instanceof Inet6Address));
            match.setField(MatchType.NW_SRC, (Object)ip, (Object)mask);
        }
        if (this.nwDst != null && !this.nwDst.trim().isEmpty()) {
            parts = this.nwDst.split("/");
            ip = NetUtils.parseInetAddress((String)parts[0]);
            mask = null;
            maskLen = 0;
            maskLen = parts.length > 1 ? Integer.parseInt(parts[1]) : (ip instanceof Inet6Address ? 128 : 32);
            mask = NetUtils.getInetNetworkMask((int)maskLen, (boolean)(ip instanceof Inet6Address));
            match.setField(MatchType.NW_DST, (Object)ip, (Object)mask);
        }
        if (IPProtocols.fromString((String)this.protocol) != IPProtocols.ANY) {
            match.setField(MatchType.NW_PROTO, (Object)IPProtocols.getProtocolNumberByte((String)this.protocol));
        }
        if (this.tpSrc != null && !this.tpSrc.trim().isEmpty()) {
            match.setField(MatchType.TP_SRC, (Object)Integer.valueOf(this.tpSrc).shortValue());
        }
        if (this.tpDst != null && !this.tpDst.trim().isEmpty()) {
            match.setField(MatchType.TP_DST, (Object)Integer.valueOf(this.tpDst).shortValue());
        }
        return match;
    }

    public String toString() {
        return "Container Flow={name:" + this.name + " dlVlan:" + this.dlVlan + " nwSrc:" + this.nwSrc + " nwDst:" + this.nwDst + " " + "protocol:" + this.protocol + " tpSrc:" + this.tpSrc + " tpDst:" + this.tpDst + "}";
    }
}

