/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.containermanager.ContainerConfig;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;

public class ContainerData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String containerAdminRole;
    private String containerOperatorRole;
    private String name;
    private ConcurrentMap<Node, Set<NodeConnector>> swPorts;
    private short staticVlan;
    private List<ContainerFlow> cFlowList;

    public ContainerData(ContainerConfig conf) {
        this.name = conf.getContainerName().toLowerCase(Locale.ENGLISH);
        this.swPorts = new ConcurrentHashMap<Node, Set<NodeConnector>>();
        this.cFlowList = new ArrayList<ContainerFlow>();
        this.staticVlan = conf.getStaticVlanValue();
        this.containerAdminRole = conf.getContainerAdminRole();
        this.containerOperatorRole = conf.getContainerOperatorRole();
    }

    public String getContainerName() {
        return this.name;
    }

    public short getStaticVlan() {
        return this.staticVlan;
    }

    public boolean hasStaticVlanAssigned() {
        return this.staticVlan != 0;
    }

    public Set<NodeConnector> getPorts(Node switchId) {
        Set swpinfo = (Set)this.swPorts.get(switchId);
        if (swpinfo != null) {
            return swpinfo;
        }
        return null;
    }

    public ConcurrentMap<Node, Set<NodeConnector>> getSwPorts() {
        return this.swPorts;
    }

    public void addPortToSwitch(NodeConnector port) {
        Node switchId = port.getNode();
        if (switchId == null) {
            return;
        }
        HashSet<NodeConnector> portSet = (HashSet<NodeConnector>)this.swPorts.get(switchId);
        if (portSet == null) {
            portSet = new HashSet<NodeConnector>();
            this.swPorts.put(switchId, portSet);
        }
        portSet.add(port);
    }

    public void removePortFromSwitch(NodeConnector port) {
        Node switchId = port.getNode();
        if (switchId == null) {
            return;
        }
        Set swpinfo = (Set)this.swPorts.get(switchId);
        if (swpinfo != null) {
            swpinfo.remove(port);
            if (swpinfo.isEmpty()) {
                this.swPorts.remove(switchId);
            }
        }
    }

    public boolean isSwitchInContainer(Node switchId) {
        return this.swPorts.containsKey(switchId);
    }

    public boolean portListEmpty(Node switchId) {
        Set swpinfo = (Set)this.swPorts.get(switchId);
        return swpinfo == null || swpinfo.isEmpty();
    }

    public void deleteFlowSpec(ContainerFlow cFlow) {
        this.cFlowList.remove(cFlow);
    }

    public void addFlowSpec(ContainerFlow cFlow) {
        this.cFlowList.add(cFlow);
    }

    public boolean isFlowSpecEmpty() {
        return this.cFlowList.isEmpty();
    }

    public boolean containsFlowSpec(ContainerFlow cFlow) {
        return this.cFlowList.contains(cFlow);
    }

    public int getFlowSpecCount() {
        return this.cFlowList.size();
    }

    public List<ContainerFlow> getContainerFlowSpecs() {
        return this.cFlowList;
    }

    public boolean matchName(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public Set<NodeConnector> getNodeConnectors() {
        HashSet<NodeConnector> set = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.swPorts.entrySet()) {
            set.addAll((Collection)entry.getValue());
        }
        return set;
    }

    public String getContainerAdminRole() {
        return this.containerAdminRole;
    }

    public String getContainerOperatorRole() {
        return this.containerOperatorRole;
    }
}

