/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.containermanager.ContainerFlowConfig;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;

@XmlRootElement(name="containerConfig")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ContainerConfig
extends ConfigurationObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String regexName = "^\\w+$";
    private static final String containerProfile = System.getProperty("container.profile") == null ? "Container" : System.getProperty("container.profile");
    private static final String ADMIN_SUFFIX = "Admin";
    private static final String OPERATOR_SUFFIX = "Operator";
    @XmlElement
    private String container;
    @XmlElement
    private String staticVlan;
    @XmlElement(name="nodeConnectors")
    private List<String> ports;
    @XmlElement(name="flowSpecs")
    private List<ContainerFlowConfig> containerFlows;

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getStaticVlan() {
        return this.staticVlan;
    }

    public void setStaticVlan(String staticVlan) {
        this.staticVlan = staticVlan;
    }

    public List<ContainerFlowConfig> getContainerFlows() {
        return this.containerFlows;
    }

    public void setContainerFlows(List<ContainerFlowConfig> containerFlows) {
        this.containerFlows = containerFlows;
    }

    public static long getSerialversionuid() {
        return 2L;
    }

    public static String getRegexname() {
        return regexName;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    public ContainerConfig() {
        this.container = null;
        this.staticVlan = null;
        this.ports = new ArrayList<String>(0);
        this.containerFlows = new ArrayList<ContainerFlowConfig>(0);
    }

    public ContainerConfig(String container, String vlan, List<String> portList, List<ContainerFlowConfig> containerFlows) {
        this.container = container;
        this.staticVlan = vlan;
        this.ports = portList == null ? new ArrayList<String>(0) : new ArrayList<String>(portList);
        this.containerFlows = containerFlows == null ? new ArrayList<ContainerFlowConfig>(0) : new ArrayList<ContainerFlowConfig>(containerFlows);
    }

    public ContainerConfig(ContainerConfig config) {
        this.container = config.container;
        this.staticVlan = config.staticVlan;
        this.ports = config.ports == null ? new ArrayList<String>(0) : new ArrayList<String>(config.ports);
        this.containerFlows = config.containerFlows == null ? new ArrayList<ContainerFlowConfig>(0) : new ArrayList<ContainerFlowConfig>(config.containerFlows);
    }

    public String getContainerName() {
        return this.container;
    }

    public String getVlanTag() {
        return this.staticVlan;
    }

    public List<String> getPorts() {
        return new ArrayList<String>(this.ports);
    }

    public List<ContainerFlowConfig> getContainerFlowConfigs() {
        return this.containerFlows == null || this.containerFlows.isEmpty() ? new ArrayList<ContainerFlowConfig>(0) : new ArrayList<ContainerFlowConfig>(this.containerFlows);
    }

    public boolean matchName(String name) {
        return this.container.equals(name);
    }

    public List<NodeConnector> getPortList() {
        ArrayList<NodeConnector> portList = new ArrayList<NodeConnector>();
        if (this.ports != null && !this.ports.isEmpty()) {
            for (String portString : this.ports) {
                portList.add(NodeConnector.fromString((String)portString));
            }
        }
        return portList;
    }

    public Status validate() {
        Status status = this.validateName();
        if (status.isSuccess() && (status = this.validateStaticVlan()).isSuccess() && (status = this.validatePorts()).isSuccess()) {
            status = this.validateContainerFlows();
        }
        return status;
    }

    private Status validateName() {
        return this.isValidResourceName(this.container) && !this.container.equalsIgnoreCase(GlobalConstants.DEFAULT.toString()) ? new Status(StatusCode.SUCCESS) : new Status(StatusCode.BADREQUEST, "Invalid container name");
    }

    private Status validatePorts() {
        return ContainerConfig.validateNodeConnectors(this.ports);
    }

    public static Status validateNodeConnectors(List<String> connectorList) {
        if (connectorList != null && !connectorList.isEmpty()) {
            for (String ncString : connectorList) {
                if (NodeConnector.fromString((String)ncString) != null) continue;
                return new Status(StatusCode.BADREQUEST, "Invalid node connector: " + ncString);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public static List<NodeConnector> nodeConnectorsFromString(List<String> nodeConnectorStrings) {
        ArrayList<NodeConnector> list = new ArrayList<NodeConnector>(nodeConnectorStrings.size());
        for (String str : nodeConnectorStrings) {
            list.add(NodeConnector.fromString((String)str));
        }
        return list;
    }

    private Status validateStaticVlan() {
        if (this.staticVlan != null && !this.staticVlan.trim().isEmpty()) {
            short vl = 0;
            try {
                vl = Short.valueOf(this.staticVlan);
            }
            catch (NumberFormatException e) {
                return new Status(StatusCode.BADREQUEST, "Static Vlan Value must be between 1 and 4095");
            }
            if (vl < 1 || vl > 4095) {
                return new Status(StatusCode.BADREQUEST, "Static Vlan Value must be between 1 and 4095");
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateContainerFlows() {
        if (this.containerFlows != null && !this.containerFlows.isEmpty()) {
            for (ContainerFlowConfig conf : this.containerFlows) {
                Status status = conf.validate();
                if (status.isSuccess()) continue;
                return new Status(StatusCode.BADREQUEST, "Invalid Flow Spec: " + status.getDescription());
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public short getStaticVlanValue() {
        if (this.staticVlan == null || this.staticVlan.trim().isEmpty()) {
            return 0;
        }
        try {
            return Short.valueOf(this.staticVlan);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Status addNodeConnectors(List<String> ncList) {
        Status status = ContainerConfig.validateNodeConnectors(ncList);
        if (!status.isSuccess()) {
            return status;
        }
        this.ports.addAll(ncList);
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeNodeConnectors(List<String> ncList) {
        Status status = ContainerConfig.validateNodeConnectors(ncList);
        if (!status.isSuccess()) {
            return status;
        }
        if (this.ports.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "The following node connectors are not part of this container: " + ncList);
        }
        ArrayList<String> extra = new ArrayList<String>(ncList);
        extra.removeAll(this.ports);
        if (!extra.isEmpty()) {
            return new Status(StatusCode.CONFLICT, "The following node connectors are not part of this container: " + extra);
        }
        this.ports.removeAll(ncList);
        return new Status(StatusCode.SUCCESS);
    }

    public Status validateContainerFlowModify(List<ContainerFlowConfig> cFlowConfigs, boolean delete) {
        block9: {
            List<String> proposedNames;
            List<String> existingNames;
            block8: {
                if (cFlowConfigs == null || cFlowConfigs.isEmpty()) {
                    return new Status(StatusCode.BADREQUEST, "Invalid Flow Spec configuration(s): null or empty list");
                }
                for (ContainerFlowConfig cFlowConf : cFlowConfigs) {
                    Status status = cFlowConf.validate();
                    if (status.isSuccess()) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Invalid Flow Spec configuration (%s): %s", cFlowConf.getName(), status.getDescription()));
                }
                existingNames = this.getContainerFlowConfigsNames();
                proposedNames = this.getContainerFlowConfigsNames(cFlowConfigs);
                if (proposedNames.size() < cFlowConfigs.size()) {
                    return new Status(StatusCode.BADREQUEST, "Invalid Flow Spec configuration(s): duplicate name configs present");
                }
                if (!delete) break block8;
                if (proposedNames.size() > existingNames.size()) {
                    return new Status(StatusCode.BADREQUEST, "Invalid request: requested to remove more flow spec configs than available ones");
                }
                for (ContainerFlowConfig config : cFlowConfigs) {
                    if (this.containerFlows.contains(config)) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Invalid request: requested to remove nonexistent flow spec config: %s", config.getName()));
                }
                break block9;
            }
            ArrayList<String> conflicting = new ArrayList<String>(existingNames);
            conflicting.retainAll(proposedNames);
            if (!conflicting.isEmpty()) {
                return new Status(StatusCode.CONFLICT, "Invalid Flow Spec configuration: flow spec name(s) conflict with existing flow specs: " + ((Object)conflicting).toString());
            }
            if (this.containerFlows == null || this.containerFlows.isEmpty()) break block9;
            HashSet<Match> existingMatches = new HashSet<Match>();
            for (ContainerFlowConfig existing : this.containerFlows) {
                existingMatches.addAll(existing.getMatches());
            }
            for (ContainerFlowConfig proposed : cFlowConfigs) {
                if (!existingMatches.removeAll(proposed.getMatches())) continue;
                return new Status(StatusCode.CONFLICT, String.format("Invalid Flow Spec configuration: %s conflicts with existing flow spec", proposed.getName()));
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public ContainerFlowConfig getContainerFlowConfig(String name) {
        if (this.containerFlows != null && !this.containerFlows.isEmpty()) {
            for (ContainerFlowConfig conf : this.containerFlows) {
                if (!conf.getName().equals(name)) continue;
                return new ContainerFlowConfig(conf);
            }
        }
        return null;
    }

    public List<String> getContainerFlowConfigsNames() {
        return this.getContainerFlowConfigsNames(this.containerFlows);
    }

    private List<String> getContainerFlowConfigsNames(List<ContainerFlowConfig> confList) {
        HashSet<String> namesSet = new HashSet<String>();
        if (confList != null) {
            for (ContainerFlowConfig conf : confList) {
                namesSet.add(conf.getName());
            }
        }
        return new ArrayList<String>(namesSet);
    }

    public Status addContainerFlows(List<ContainerFlowConfig> containerFlowConfigs) {
        Status status = this.validateContainerFlowModify(containerFlowConfigs, false);
        if (!status.isSuccess()) {
            return status;
        }
        if (!this.containerFlows.addAll(containerFlowConfigs)) {
            return new Status(StatusCode.INTERNALERROR, "Unable to update the flow spec configuration(s)");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeContainerFlows(List<ContainerFlowConfig> containerFlowConfigs) {
        Status status = this.validateContainerFlowModify(containerFlowConfigs, true);
        if (!status.isSuccess()) {
            return status;
        }
        if (!this.containerFlows.removeAll(containerFlowConfigs)) {
            return new Status(StatusCode.INTERNALERROR, "Unable to update the flow spec configuration(s)");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeContainerFlows(Set<String> names) {
        if (names == null || names.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid flow spec names list");
        }
        List<String> present = this.getContainerFlowConfigsNames();
        if (!present.containsAll(names)) {
            ArrayList<String> notPresent = new ArrayList<String>(names);
            notPresent.retainAll(present);
            return new Status(StatusCode.BADREQUEST, "Following flow spec(s) are not present: " + notPresent);
        }
        ArrayList<ContainerFlowConfig> toDelete = new ArrayList<ContainerFlowConfig>(names.size());
        for (ContainerFlowConfig config : this.containerFlows) {
            if (!names.contains(config.getName())) continue;
            toDelete.add(config);
        }
        if (!this.containerFlows.removeAll(toDelete)) {
            return new Status(StatusCode.INTERNALERROR, "Unable to remove the flow spec configuration(s)");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public List<ContainerFlowConfig> getContainerFlowConfigs(Set<String> names) {
        ArrayList<ContainerFlowConfig> list = new ArrayList<ContainerFlowConfig>(names.size());
        for (String name : names) {
            ContainerFlowConfig conf = this.getContainerFlowConfig(name);
            if (conf == null) continue;
            list.add(new ContainerFlowConfig(conf));
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerFlows == null ? 0 : this.containerFlows.hashCode());
        result = 31 * result + (this.ports == null ? 0 : this.ports.hashCode());
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.staticVlan == null ? 0 : this.staticVlan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerConfig other = (ContainerConfig)obj;
        if (this.containerFlows == null ? other.containerFlows != null : !this.containerFlows.equals(other.containerFlows)) {
            return false;
        }
        if (this.ports == null ? other.ports != null : !this.ports.equals(other.ports)) {
            return false;
        }
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return !(this.staticVlan == null ? other.staticVlan != null : !this.staticVlan.equals(other.staticVlan));
    }

    public String toString() {
        String vlString = "";
        if (this.staticVlan != null) {
            vlString = this.staticVlan;
        }
        return "container=" + this.container + (vlString.equals("") ? "" : " static Vlan=" + vlString) + " ports=" + this.ports + " flowspecs=" + this.containerFlows;
    }

    public boolean hasNodeConnectors() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public boolean hasFlowSpecs() {
        return this.containerFlows != null && !this.containerFlows.isEmpty();
    }

    public List<ContainerFlow> getContainerFlowSpecs() {
        ArrayList<ContainerFlow> list = new ArrayList<ContainerFlow>();
        if (this.containerFlows != null && !this.containerFlows.isEmpty()) {
            for (ContainerFlowConfig flowSpec : this.containerFlows) {
                for (Match match : flowSpec.getMatches()) {
                    list.add(new ContainerFlow(match));
                }
            }
        }
        return list;
    }

    private String getContainerRole(boolean admin) {
        return String.format("%s-%s-%s", containerProfile, this.container, admin ? ADMIN_SUFFIX : OPERATOR_SUFFIX);
    }

    public String getContainerAdminRole() {
        return this.getContainerRole(true);
    }

    public String getContainerOperatorRole() {
        return this.getContainerRole(false);
    }

    public String getContainerGroupName() {
        return String.format("%s-%s", containerProfile, this.container);
    }
}

