/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.md.controller.topology.lldp.utils;

import java.nio.charset.Charset;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.LLDP;
import org.opendaylight.controller.sal.packet.LLDPTLV;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLDPDiscoveryUtils {
    static Logger LOG = LoggerFactory.getLogger(LLDPDiscoveryUtils.class);
    public static final Long LLDP_INTERVAL = 5000L;
    public static final Long LLDP_EXPIRATION_TIME = LLDP_INTERVAL * 3L;

    public static String macToString(byte[] mac) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            b.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
        }
        return b.toString();
    }

    public static NodeConnectorRef lldpToNodeConnectorRef(byte[] payload) {
        Ethernet ethPkt = new Ethernet();
        try {
            ethPkt.deserialize(payload, 0, payload.length * 8);
        }
        catch (Exception e) {
            LOG.warn("Failed to decode LLDP packet {}", (Throwable)e);
        }
        if (ethPkt.getPayload() instanceof LLDP) {
            LLDP lldp = (LLDP)ethPkt.getPayload();
            try {
                NodeId srcNodeId = null;
                NodeConnectorId srcNodeConnectorId = null;
                for (LLDPTLV lldptlv : lldp.getOptionalTLVList()) {
                    if (lldptlv.getType() == LLDPTLV.TLVType.Custom.getValue()) {
                        srcNodeConnectorId = new NodeConnectorId(LLDPTLV.getCustomString((byte[])lldptlv.getValue(), (int)lldptlv.getLength()));
                    }
                    if (lldptlv.getType() != LLDPTLV.TLVType.SystemName.getValue()) continue;
                    String srcNodeIdString = new String(lldptlv.getValue(), Charset.defaultCharset());
                    srcNodeId = new NodeId(srcNodeIdString);
                }
                if (srcNodeId != null && srcNodeConnectorId != null) {
                    InstanceIdentifier srcInstanceId = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)new NodeKey(srcNodeId)).child(NodeConnector.class, (Identifier)new NodeConnectorKey(srcNodeConnectorId)).toInstance();
                    return new NodeConnectorRef(srcInstanceId);
                }
            }
            catch (Exception e) {
                LOG.warn("Caught exception ", (Throwable)e);
            }
        }
        return null;
    }
}

