/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.md.controller.topology.lldp;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.md.controller.topology.lldp.LLDPDiscoveryProvider;
import org.opendaylight.md.controller.topology.lldp.utils.LLDPDiscoveryUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.Link;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkDiscovered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.topology.discovery.rev130819.LinkRemovedBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class LLDPLinkAger {
    private static final LLDPLinkAger instance = new LLDPLinkAger();
    private Map<LinkDiscovered, Date> linkToDate = new ConcurrentHashMap<LinkDiscovered, Date>();
    private LLDPDiscoveryProvider manager;
    private Timer timer = new Timer();

    public LLDPDiscoveryProvider getManager() {
        return this.manager;
    }

    public void setManager(LLDPDiscoveryProvider manager) {
        this.manager = manager;
    }

    private LLDPLinkAger() {
        this.timer.schedule((TimerTask)new LLDPAgingTask(), 0L, (long)LLDPDiscoveryUtils.LLDP_INTERVAL);
    }

    public static LLDPLinkAger getInstance() {
        return instance;
    }

    public void put(LinkDiscovered link) {
        Date expires = new Date();
        expires.setTime(expires.getTime() + LLDPDiscoveryUtils.LLDP_EXPIRATION_TIME);
        this.linkToDate.put(link, expires);
    }

    public void close() {
        this.timer.cancel();
    }

    private class LLDPAgingTask
    extends TimerTask {
        private LLDPAgingTask() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : LLDPLinkAger.this.linkToDate.entrySet()) {
                LinkDiscovered link = (LinkDiscovered)entry.getKey();
                Date now = new Date();
                Date expires = (Date)entry.getValue();
                if (!now.after(expires) || LLDPLinkAger.getInstance().getManager() == null) continue;
                LinkRemovedBuilder lrb = new LinkRemovedBuilder((Link)link);
                LLDPLinkAger.getInstance().getManager().getNotificationService().publish((Notification)lrb.build());
                LLDPLinkAger.this.linkToDate.remove(link);
            }
        }
    }
}

