/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.services_implementation.internal;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.CacheListenerAddException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.clustering.services.IClusterServicesCommon;
import org.opendaylight.controller.clustering.services.ICoordinatorChangeAware;
import org.opendaylight.controller.clustering.services.IGetUpdates;
import org.opendaylight.controller.clustering.services.IListenRoleChange;
import org.opendaylight.controller.clustering.services.ListenRoleChangeAddException;
import org.opendaylight.controller.clustering.services_implementation.internal.GetUpdatesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterManagerCommon
implements IClusterServicesCommon {
    protected String containerName = null;
    protected IClusterServices clusterService = null;
    protected static final Logger logger = LoggerFactory.getLogger(ClusterManagerCommon.class);
    private ConcurrentMap<String, GetUpdatesContainer> cacheUpdateAware = new ConcurrentHashMap<String, GetUpdatesContainer>();
    private Set<ICoordinatorChangeAware> coordinatorChangeAware = Collections.synchronizedSet(new HashSet());
    private ListenCoordinatorChange coordinatorChangeListener = null;

    void setCoordinatorChangeAware(ICoordinatorChangeAware s) {
        if (this.coordinatorChangeAware != null) {
            this.coordinatorChangeAware.add(s);
        }
    }

    void unsetCoordinatorChangeAware(ICoordinatorChangeAware s) {
        if (this.coordinatorChangeAware != null) {
            this.coordinatorChangeAware.remove(s);
        }
    }

    void setCacheUpdateAware(Map props, ICacheUpdateAware s) {
        Set caches;
        logger.trace("CacheUpdateAware being set on container:{}", (Object)this.containerName);
        if (this.cacheUpdateAware != null && (caches = (Set)props.get("cachenames")) != null) {
            logger.trace("cachenames provided below:");
            for (String cache : caches) {
                if (this.cacheUpdateAware.get(cache) != null) {
                    logger.error("cachename:{} on container:{} has already a listener", (Object)cache, (Object)this.containerName);
                    continue;
                }
                GetUpdatesContainer up = new GetUpdatesContainer(s, this.containerName, cache);
                if (up == null) continue;
                try {
                    this.clusterService.addListener(this.containerName, cache, up);
                    this.cacheUpdateAware.put(cache, up);
                    logger.trace("cachename:{} on container:{} has been registered", (Object)cache, (Object)this.containerName);
                }
                catch (CacheListenerAddException exc) {}
            }
        }
    }

    void unsetCacheUpdateAware(Map props, ICacheUpdateAware s) {
        Set caches;
        logger.trace("CacheUpdateAware being unset on container:{}", (Object)this.containerName);
        if (this.cacheUpdateAware != null && (caches = (Set)props.get("cachenames")) != null) {
            logger.trace("cachenames provided below:");
            GetUpdatesContainer up = null;
            for (String cache : caches) {
                up = (GetUpdatesContainer)this.cacheUpdateAware.get(cache);
                if (up == null) continue;
                this.cacheUpdateAware.remove(cache);
                this.clusterService.removeListener(this.containerName, cache, (IGetUpdates)up);
            }
        }
    }

    public void setClusterService(IClusterServices s) {
        this.clusterService = s;
    }

    public void unsetClusterServices(IClusterServices s) {
        if (this.clusterService == s) {
            this.clusterService = null;
        }
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        if (this.clusterService != null) {
            this.coordinatorChangeListener = new ListenCoordinatorChange();
            try {
                this.clusterService.listenRoleChange((IListenRoleChange)this.coordinatorChangeListener);
                logger.debug("Coordinator change handler registered");
            }
            catch (ListenRoleChangeAddException ex) {
                logger.error("Could not register coordinator change");
            }
        }
    }

    void destroy() {
        if (this.clusterService != null && this.coordinatorChangeListener != null) {
            this.clusterService.unlistenRoleChange((IListenRoleChange)this.coordinatorChangeListener);
            this.coordinatorChangeListener = null;
            logger.debug("Coordinator change handler UNregistered");
        }
    }

    public ConcurrentMap<?, ?> createCache(String cacheName, Set<IClusterServices.cacheMode> cMode) throws CacheExistException, CacheConfigException {
        if (this.clusterService != null) {
            return this.clusterService.createCache(this.containerName, cacheName, cMode);
        }
        return null;
    }

    public ConcurrentMap<?, ?> getCache(String cacheName) {
        if (this.clusterService != null) {
            return this.clusterService.getCache(this.containerName, cacheName);
        }
        return null;
    }

    public void destroyCache(String cacheName) {
        if (this.clusterService != null) {
            this.clusterService.destroyCache(this.containerName, cacheName);
        }
    }

    public boolean existCache(String cacheName) {
        if (this.clusterService != null) {
            return this.clusterService.existCache(this.containerName, cacheName);
        }
        return false;
    }

    public Set<String> getCacheList() {
        if (this.clusterService != null) {
            return this.clusterService.getCacheList(this.containerName);
        }
        return null;
    }

    public Properties getCacheProperties(String cacheName) {
        if (this.clusterService != null) {
            return this.clusterService.getCacheProperties(this.containerName, cacheName);
        }
        return null;
    }

    public void tbegin() throws NotSupportedException, SystemException {
        if (this.clusterService == null) {
            throw new IllegalStateException();
        }
        this.clusterService.tbegin();
    }

    public void tbegin(long timeout, TimeUnit unit) throws NotSupportedException, SystemException {
        if (this.clusterService == null) {
            throw new IllegalStateException();
        }
        this.clusterService.tbegin(timeout, unit);
    }

    public void tcommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.clusterService == null) {
            throw new IllegalStateException();
        }
        this.clusterService.tcommit();
    }

    public void trollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.clusterService == null) {
            throw new IllegalStateException();
        }
        this.clusterService.trollback();
    }

    public Transaction tgetTransaction() throws SystemException {
        if (this.clusterService != null) {
            return this.clusterService.tgetTransaction();
        }
        return null;
    }

    public List<InetAddress> getClusteredControllers() {
        if (this.clusterService != null) {
            return this.clusterService.getClusteredControllers();
        }
        return null;
    }

    public InetAddress getMyAddress() {
        if (this.clusterService != null) {
            return this.clusterService.getMyAddress();
        }
        return null;
    }

    public InetAddress getCoordinatorAddress() {
        if (this.clusterService != null) {
            return this.clusterService.getActiveAddress();
        }
        return null;
    }

    public boolean amICoordinator() {
        if (this.clusterService != null) {
            return !this.clusterService.amIStandby();
        }
        return false;
    }

    class ListenCoordinatorChange
    implements IListenRoleChange {
        ListenCoordinatorChange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newActiveAvailable() {
            if (ClusterManagerCommon.this.coordinatorChangeAware != null) {
                Set set = ClusterManagerCommon.this.coordinatorChangeAware;
                synchronized (set) {
                    for (ICoordinatorChangeAware s : ClusterManagerCommon.this.coordinatorChangeAware) {
                        s.coordinatorChanged();
                    }
                }
            }
        }
    }
}

