/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.services_implementation.internal;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.IpAddress;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.CacheListenerAddException;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.clustering.services.IGetUpdates;
import org.opendaylight.controller.clustering.services.IListenRoleChange;
import org.opendaylight.controller.clustering.services.ListenRoleChangeAddException;
import org.opendaylight.controller.clustering.services_implementation.internal.CacheListenerContainer;
import org.opendaylight.controller.clustering.services_implementation.internal.ClassResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager
implements IClusterServices {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterManager.class);
    private DefaultCacheManager cm;
    GossipRouter gossiper;
    private HashSet<IListenRoleChange> roleChangeListeners;
    private ViewChangedListener cacheManagerListener;
    private static String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
    private static final int gossipRouterPortDefault = 12001;
    private static int DEFAULT_TRANSACTION_TIMEOUT = 60;

    private GossipRouter startGossiper() {
        StringTokenizer supernodes;
        boolean amIGossipRouter = false;
        Integer gossipRouterPort = 12001;
        InetAddress gossipRouterAddress = null;
        String supernodes_list = System.getProperty("supernodes", loopbackAddress);
        boolean inContainer = "lxc".equals(System.getenv("container"));
        StringBuffer sanitized_supernodes_list = new StringBuffer();
        ArrayList<InetAddress> myAddresses = new ArrayList<InetAddress>();
        if (inContainer) {
            logger.trace("DOCKER: Resolving supernode host names using docker container semantics");
        }
        if ((supernodes = new StringTokenizer(supernodes_list, ":")).hasMoreTokens()) {
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface n = e.nextElement();
                    Enumeration<InetAddress> ee = n.getInetAddresses();
                    while (ee.hasMoreElements()) {
                        InetAddress i = ee.nextElement();
                        myAddresses.add(i);
                    }
                }
            }
            catch (SocketException se) {
                logger.error("Cannot get the list of network interfaces");
                return null;
            }
        }
        while (supernodes.hasMoreTokens()) {
            InetAddress hostAddr;
            String curr_supernode = supernodes.nextToken();
            logger.debug("Examining supernode {}", (Object)curr_supernode);
            StringTokenizer host_port = new StringTokenizer(curr_supernode, "[]");
            Integer port_num = 12001;
            if (host_port.countTokens() > 2) {
                logger.error("Error parsing supernode {} proceed to the next one", (Object)curr_supernode);
                continue;
            }
            String host = host_port.nextToken();
            if (inContainer && host != null && host.charAt(0) == '+') {
                if ("+self".equals(host)) {
                    host = System.getenv("HOSTNAME");
                } else {
                    String link = System.getenv(host.substring(1).toUpperCase() + "_PORT");
                    if (link != null) {
                        try {
                            host = new URI(link).getHost();
                        }
                        catch (URISyntaxException e) {
                            logger.error("DOCKER: Unable to translate container reference ({}) to host IP Address, will attempt using normal host name", (Object)host.substring(1));
                        }
                    }
                }
            }
            try {
                hostAddr = InetAddress.getByName(host);
            }
            catch (UnknownHostException ue) {
                logger.error("Host {} is not known", (Object)host);
                continue;
            }
            if (host_port.hasMoreTokens()) {
                String port = host_port.nextToken();
                try {
                    port_num = Integer.valueOf(port);
                }
                catch (NumberFormatException ne) {
                    logger.error("Supplied supernode gossip port is not recognized, using default gossip port {}", (Object)12001);
                    port_num = 12001;
                }
                if (port_num > 65535 || port_num < 0) {
                    logger.error("Supplied supernode gossip port is outside a valid TCP port range");
                    port_num = 12001;
                }
            }
            if (!amIGossipRouter && host != null) {
                for (InetAddress myAddr : myAddresses) {
                    if (!myAddr.equals(hostAddr)) continue;
                    amIGossipRouter = true;
                    gossipRouterAddress = hostAddr;
                    gossipRouterPort = port_num;
                    break;
                }
            }
            if (!sanitized_supernodes_list.toString().equals("")) {
                sanitized_supernodes_list.append(",");
            }
            sanitized_supernodes_list.append(hostAddr.getHostAddress()).append("[").append(port_num).append("]");
        }
        if (amIGossipRouter) {
            if (gossipRouterAddress != null) {
                System.setProperty("jgroups.tcp.address", gossipRouterAddress.getHostAddress());
            }
        } else {
            try {
                String jgroupAddress;
                String myBind = InetAddress.getLocalHost().getHostAddress();
                if (myBind == null || InetAddress.getLocalHost().isLoopbackAddress()) {
                    for (InetAddress myAddr : myAddresses) {
                        if (myAddr.isLoopbackAddress() || myAddr.isLinkLocalAddress()) {
                            logger.debug("Skipping local address {}", (Object)myAddr.getHostAddress());
                            continue;
                        }
                        myBind = myAddr.getHostAddress();
                        logger.debug("First non-local address {}", (Object)myBind);
                        break;
                    }
                }
                if ((jgroupAddress = System.getProperty("jgroups.tcp.address")) == null) {
                    if (myBind != null) {
                        logger.debug("Set bind address to be {}", (Object)myBind);
                        System.setProperty("jgroups.tcp.address", myBind);
                    } else {
                        logger.debug("Set bind address to be LOCALHOST=127.0.0.1");
                        System.setProperty("jgroups.tcp.address", "127.0.0.1");
                    }
                } else {
                    logger.debug("jgroup.tcp.address already set to be {}", (Object)jgroupAddress);
                }
            }
            catch (UnknownHostException uhe) {
                logger.error("Met UnknownHostException while trying to get binding address for jgroups");
            }
        }
        System.setProperty("jgroups.tcpgossip.initial_hosts", sanitized_supernodes_list.toString());
        logger.debug("jgroups.tcp.address set to {}", (Object)System.getProperty("jgroups.tcp.address"));
        logger.debug("jgroups.tcpgossip.initial_hosts set to {}", (Object)System.getProperty("jgroups.tcpgossip.initial_hosts"));
        GossipRouter res = null;
        if (amIGossipRouter) {
            logger.info("I'm a GossipRouter will listen on port {}", (Object)gossipRouterPort);
            res = new GossipRouter(gossipRouterPort.intValue(), null, true);
        }
        return res;
    }

    private void exitOnSecurityException(Exception ioe) {
        for (Throwable cause = ioe.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SecurityException)) continue;
            logger.error("Failed Cluster authentication. Stopping Controller...");
            System.exit(0);
        }
    }

    public void start() {
        this.gossiper = this.startGossiper();
        if (this.gossiper != null) {
            logger.debug("Trying to start Gossiper");
            try {
                this.gossiper.start();
                logger.info("Started GossipRouter");
            }
            catch (Exception e) {
                logger.error("GossipRouter didn't start. Exception Stack Trace", (Throwable)e);
            }
        }
        logger.info("Starting the ClusterManager");
        try {
            ParserRegistry parser = new ParserRegistry(this.getClass().getClassLoader());
            String infinispanConfigFile = System.getProperty("org.infinispan.config.file", "config/infinispan-config.xml");
            logger.debug("Using configuration file:{}", (Object)infinispanConfigFile);
            ConfigurationBuilderHolder holder = parser.parseFile(infinispanConfigFile);
            GlobalConfigurationBuilder globalBuilder = holder.getGlobalConfigurationBuilder();
            globalBuilder.serialization().classResolver((org.jboss.marshalling.ClassResolver)new ClassResolver()).build();
            this.cm = new DefaultCacheManager(holder, false);
            logger.debug("Allocated ClusterManager");
            if (this.cm != null) {
                this.cm.start();
                this.cm.startCache();
                logger.debug("Started the ClusterManager");
            }
        }
        catch (Exception ioe) {
            logger.error("Cannot configure infinispan .. bailing out ");
            logger.error("Stack Trace that raised th exception");
            logger.error("", (Throwable)ioe);
            this.cm = null;
            this.exitOnSecurityException(ioe);
            this.stop();
        }
        logger.debug("Cache Manager has value {}", (Object)this.cm);
    }

    public void stop() {
        logger.info("Stopping the ClusterManager");
        if (this.cm != null) {
            logger.info("Found a valid ClusterManager, now let it be stopped");
            this.cm.stop();
            this.cm = null;
        }
        if (this.gossiper != null) {
            this.gossiper.stop();
            this.gossiper = null;
        }
    }

    public ConcurrentMap<?, ?> createCache(String containerName, String cacheName, Set<IClusterServices.cacheMode> cMode) throws CacheExistException, CacheConfigException {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return null;
        }
        if (manager.cacheExists(realCacheName)) {
            throw new CacheExistException();
        }
        if (cMode.containsAll(EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL, IClusterServices.cacheMode.TRANSACTIONAL))) {
            throw new CacheConfigException();
        }
        if (cMode.containsAll(EnumSet.of(IClusterServices.cacheMode.SYNC, IClusterServices.cacheMode.ASYNC))) {
            throw new CacheConfigException();
        }
        Configuration fromTemplateConfig = null;
        if (cMode.contains(IClusterServices.cacheMode.TRANSACTIONAL)) {
            fromTemplateConfig = manager.getCacheConfiguration("transactional-type");
        } else if (cMode.contains(IClusterServices.cacheMode.NON_TRANSACTIONAL)) {
            fromTemplateConfig = manager.getDefaultCacheConfiguration();
        }
        if (fromTemplateConfig == null) {
            return null;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.read(fromTemplateConfig);
        if (cMode.contains(IClusterServices.cacheMode.ASYNC)) {
            builder.clustering().cacheMode(fromTemplateConfig.clustering().cacheMode().toAsync());
        } else if (cMode.contains(IClusterServices.cacheMode.SYNC)) {
            builder.clustering().cacheMode(fromTemplateConfig.clustering().cacheMode().toSync());
        }
        manager.defineConfiguration(realCacheName, builder.build());
        Cache c = manager.getCache(realCacheName);
        return c;
    }

    public ConcurrentMap<?, ?> getCache(String containerName, String cacheName) {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return null;
        }
        if (manager.cacheExists(realCacheName)) {
            Cache c = manager.getCache(realCacheName);
            return c;
        }
        return null;
    }

    public void destroyCache(String containerName, String cacheName) {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return;
        }
        if (manager.cacheExists(realCacheName)) {
            manager.removeCache(realCacheName);
        }
    }

    public boolean existCache(String containerName, String cacheName) {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return false;
        }
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        return manager.cacheExists(realCacheName);
    }

    public Set<String> getCacheList(String containerName) {
        HashSet<String> perContainerCaches = new HashSet<String>();
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return null;
        }
        for (String cacheName : manager.getCacheNames()) {
            String[] res;
            if (!manager.isRunning(cacheName) || !cacheName.startsWith("{" + containerName + "}_") || (res = cacheName.split("[{}]")).length < 4 || !res[1].equals(containerName) || !res[2].equals("_")) continue;
            perContainerCaches.add(res[3]);
        }
        return perContainerCaches;
    }

    public Properties getCacheProperties(String containerName, String cacheName) {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return null;
        }
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (!manager.cacheExists(realCacheName)) {
            return null;
        }
        Configuration conf = manager.getCache(realCacheName).getAdvancedCache().getCacheConfiguration();
        Properties p = new Properties();
        p.setProperty(IClusterServices.cacheProps.TRANSACTION_PROP.toString(), conf.transaction().toString());
        p.setProperty(IClusterServices.cacheProps.CLUSTERING_PROP.toString(), conf.clustering().toString());
        p.setProperty(IClusterServices.cacheProps.LOCKING_PROP.toString(), conf.locking().toString());
        return p;
    }

    public void addListener(String containerName, String cacheName, IGetUpdates<?, ?> u) throws CacheListenerAddException {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return;
        }
        if (!manager.cacheExists(realCacheName)) {
            throw new CacheListenerAddException();
        }
        Cache c = manager.getCache(realCacheName);
        CacheListenerContainer cl = new CacheListenerContainer(u, containerName, cacheName);
        c.addListener((Object)cl);
    }

    public Set<IGetUpdates<?, ?>> getListeners(String containerName, String cacheName) {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return null;
        }
        if (!manager.cacheExists(realCacheName)) {
            return null;
        }
        Cache c = manager.getCache(realCacheName);
        HashSet res = new HashSet();
        Set listeners = c.getListeners();
        for (Object listener : listeners) {
            if (!(listener instanceof CacheListenerContainer)) continue;
            CacheListenerContainer cl = (CacheListenerContainer)listener;
            res.add(cl.whichListener());
        }
        return res;
    }

    public void removeListener(String containerName, String cacheName, IGetUpdates<?, ?> u) {
        DefaultCacheManager manager = this.cm;
        String realCacheName = "{" + containerName + "}_{" + cacheName + "}";
        if (manager == null) {
            return;
        }
        if (!manager.cacheExists(realCacheName)) {
            return;
        }
        Cache c = manager.getCache(realCacheName);
        Set listeners = c.getListeners();
        for (Object listener : listeners) {
            CacheListenerContainer cl;
            if (!(listener instanceof CacheListenerContainer) || (cl = (CacheListenerContainer)listener).whichListener() != u) continue;
            c.removeListener(listener);
            return;
        }
    }

    public void tbegin() throws NotSupportedException, SystemException {
        this.tbegin(DEFAULT_TRANSACTION_TIMEOUT, TimeUnit.SECONDS);
    }

    public void tbegin(long timeout, TimeUnit unit) throws NotSupportedException, SystemException {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            throw new IllegalStateException();
        }
        TransactionManager tm = manager.getCache("transactional-type").getAdvancedCache().getTransactionManager();
        if (tm == null) {
            throw new IllegalStateException();
        }
        long timeoutSec = unit.toSeconds(timeout);
        if (timeoutSec > Integer.MAX_VALUE || timeoutSec <= 0L) {
            tm.setTransactionTimeout(DEFAULT_TRANSACTION_TIMEOUT);
        } else {
            tm.setTransactionTimeout((int)timeoutSec);
        }
        tm.begin();
    }

    public void tcommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            throw new IllegalStateException();
        }
        TransactionManager tm = manager.getCache("transactional-type").getAdvancedCache().getTransactionManager();
        if (tm == null) {
            throw new IllegalStateException();
        }
        tm.commit();
    }

    public void trollback() throws IllegalStateException, SecurityException, SystemException {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            throw new IllegalStateException();
        }
        TransactionManager tm = manager.getCache("transactional-type").getAdvancedCache().getTransactionManager();
        if (tm == null) {
            throw new IllegalStateException();
        }
        tm.rollback();
    }

    public Transaction tgetTransaction() throws SystemException {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            throw new IllegalStateException();
        }
        TransactionManager tm = manager.getCache("transactional-type").getAdvancedCache().getTransactionManager();
        if (tm == null) {
            return null;
        }
        return tm.getTransaction();
    }

    public boolean amIStandby() {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return true;
        }
        return !manager.isCoordinator();
    }

    private InetAddress addressToInetAddress(Address a) {
        DefaultCacheManager manager = this.cm;
        if (manager == null || a == null) {
            return null;
        }
        Transport t = manager.getTransport();
        if (t instanceof JGroupsTransport) {
            JGroupsAddress ja;
            org.jgroups.Address phys;
            JGroupsTransport jt = (JGroupsTransport)t;
            Channel c = jt.getChannel();
            if (a instanceof JGroupsAddress && (phys = (org.jgroups.Address)c.down(new Event(87, (Object)(ja = (JGroupsAddress)a).getJGroupsAddress()))) instanceof IpAddress) {
                InetAddress bindAddress = ((IpAddress)phys).getIpAddress();
                return bindAddress;
            }
        }
        return null;
    }

    public List<InetAddress> getClusteredControllers() {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return null;
        }
        List controllers = manager.getMembers();
        if (controllers == null || controllers.size() == 0) {
            return null;
        }
        ArrayList<InetAddress> clusteredControllers = new ArrayList<InetAddress>();
        for (Address a : controllers) {
            InetAddress inetAddress = this.addressToInetAddress(a);
            if (inetAddress == null || inetAddress.getHostAddress().equals(loopbackAddress)) continue;
            clusteredControllers.add(inetAddress);
        }
        return clusteredControllers;
    }

    public InetAddress getMyAddress() {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return null;
        }
        return this.addressToInetAddress(manager.getAddress());
    }

    public InetAddress getActiveAddress() {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return null;
        }
        return this.addressToInetAddress(manager.getCoordinator());
    }

    public void listenRoleChange(IListenRoleChange i) throws ListenRoleChangeAddException {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            throw new ListenRoleChangeAddException();
        }
        if (this.roleChangeListeners == null) {
            this.roleChangeListeners = new HashSet();
            this.cacheManagerListener = new ViewChangedListener(this.roleChangeListeners);
            manager.addListener((Object)this.cacheManagerListener);
        }
        if (this.roleChangeListeners != null) {
            this.roleChangeListeners.add(i);
        }
    }

    public void unlistenRoleChange(IListenRoleChange i) {
        DefaultCacheManager manager = this.cm;
        if (manager == null) {
            return;
        }
        if (this.roleChangeListeners != null) {
            this.roleChangeListeners.remove(i);
        }
        if (this.roleChangeListeners != null && this.roleChangeListeners.isEmpty() && this.cacheManagerListener != null) {
            manager.removeListener((Object)this.cacheManagerListener);
            this.cacheManagerListener = null;
            this.roleChangeListeners = null;
        }
    }

    @Listener
    public class ViewChangedListener {
        Set<IListenRoleChange> roleListeners;

        public ViewChangedListener(Set<IListenRoleChange> s) {
            this.roleListeners = s;
        }

        @ViewChanged
        public void viewChanged(ViewChangedEvent e) {
            for (IListenRoleChange i : this.roleListeners) {
                i.newActiveAvailable();
            }
        }
    }
}

