/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.services_implementation.internal;

import java.util.Map;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services_implementation.internal.ClusterManagerCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterGlobalManager
extends ClusterManagerCommon
implements IClusterGlobalServices {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterGlobalManager.class);

    @Override
    void setCacheUpdateAware(Map props, ICacheUpdateAware s) {
        logger.trace("setCacheUpdateAware");
        if (props.get("containerName") != null) {
            return;
        }
        super.setCacheUpdateAware(props, s);
    }

    @Override
    void unsetCacheUpdateAware(Map props, ICacheUpdateAware s) {
        logger.trace("unsetCacheUpdateAware");
        if (props.get("containerName") != null) {
            return;
        }
        super.unsetCacheUpdateAware(props, s);
    }

    public void removeContainerCaches(String containerName) {
        logger.debug("Removing caches for container {}", (Object)containerName);
        for (String cacheName : this.clusterService.getCacheList(containerName)) {
            this.clusterService.destroyCache(containerName, cacheName);
        }
    }
}

