/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.services_implementation.internal;

import java.lang.ref.WeakReference;
import org.jboss.marshalling.ContextClassResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassResolver
extends ContextClassResolver {
    private WeakReference<ClassLoader> osgiClassLoader = null;
    private static final Logger logger = LoggerFactory.getLogger(ClassResolver.class);

    public ClassResolver() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl != null) {
            this.osgiClassLoader = new WeakReference<ClassLoader>(cl);
            logger.trace("Acquired weak reference to OSGi classLoader {}", (Object)cl);
        }
    }

    protected ClassLoader getClassLoader() {
        ClassLoader ret = null;
        if (this.osgiClassLoader != null && (ret = (ClassLoader)this.osgiClassLoader.get()) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Returning OSGi class loader {}", (Object)ret);
            }
            return ret;
        }
        logger.warn("Could not resolve classloader!");
        return ret;
    }
}

