/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1NonTxInterceptor
extends BaseRpcInterceptor {
    private static Log log = LogFactory.getLog(L1NonTxInterceptor.class);
    private L1Manager l1Manager;
    private ClusteringDependentLogic cdl;
    private CommandsFactory cf;
    private LockManager lockManager;
    private EntryFactory entryFactory;

    @Inject
    public void init(L1Manager l1Manager, ClusteringDependentLogic cdl, LockManager lockManager, EntryFactory entryFactory, CommandsFactory cf) {
        this.l1Manager = l1Manager;
        this.cdl = cdl;
        this.lockManager = lockManager;
        this.entryFactory = entryFactory;
        this.cf = cf;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        InternalCacheEntry ice = command.getRemotelyFetchedValue();
        if (ctx.isOriginLocal() && ice != null) {
            log.tracef("Caching remotely retrieved entry for key %s in L1", command.getKey());
            try {
                long l1Lifespan = this.cacheConfiguration.clustering().l1().lifespan();
                long lifespan = ice.getLifespan() < 0L ? l1Lifespan : Math.min(ice.getLifespan(), l1Lifespan);
                Metadata newMetadata = ice.getMetadata().builder().lifespan(lifespan).maxIdle(-1L).build();
                PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), newMetadata, Collections.singleton(Flag.CACHE_MODE_LOCAL));
                this.lockAndWrap(ctx, command.getKey(), ice, (FlagAffectedCommand)command);
                this.invokeNextInterceptor(ctx, (VisitableCommand)put);
            }
            catch (Exception e) {
                log.infof("Unable to store entry %s in L1 cache", command.getKey());
                log.debug((Object)"Inability to store in L1 caused by", (Throwable)e);
            }
        } else if (!ctx.isOriginLocal() && returnValue != null) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        return returnValue;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command, true);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command, false);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command, true);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Future invalidationFuture = null;
        Set keys = command.getMap().keySet();
        HashSet toInvalidate = new HashSet(keys.size());
        for (Object k : keys) {
            if (!this.cdl.localNodeIsOwner(k)) continue;
            toInvalidate.add(k);
        }
        if (!toInvalidate.isEmpty()) {
            invalidationFuture = this.l1Manager.flushCache(toInvalidate, ctx.getOrigin(), true);
        }
        Object result = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processInvalidationResult(ctx, (FlagAffectedCommand)command, invalidationFuture);
        for (Object o : command.getAffectedKeys()) {
            if (this.cdl.localNodeIsOwner(o)) continue;
            this.removeFromL1(ctx, o);
        }
        return result;
    }

    private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command, boolean assumeOriginKeptEntryInL1) throws Throwable {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            log.tracef("local mode forced, suppressing L1 calls.", new Object[0]);
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }
        Future<Object> l1InvalidationFuture = this.invalidateL1(ctx, command, assumeOriginKeptEntryInL1);
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processInvalidationResult(ctx, (FlagAffectedCommand)command, l1InvalidationFuture);
        this.removeFromLocalL1(ctx, command);
        return returnValue;
    }

    private void removeFromLocalL1(InvocationContext ctx, DataWriteCommand command) throws InterruptedException {
        if (ctx.isOriginLocal() && !this.cdl.localNodeIsOwner(command.getKey())) {
            this.removeFromL1(ctx, command.getKey());
        } else {
            log.trace((Object)"Allowing entry to commit as local node is owner");
        }
    }

    private void removeFromL1(InvocationContext ctx, Object key) throws InterruptedException {
        log.tracef("Removing entry from L1 for key %s", key);
        ctx.removeLookedUpEntry(key);
        this.entryFactory.wrapEntryForRemove(ctx, key);
    }

    private void processInvalidationResult(InvocationContext ctx, FlagAffectedCommand command, Future<Object> l1InvalidationFuture) throws InterruptedException, ExecutionException {
        if (l1InvalidationFuture != null && this.isSynchronous(command)) {
            l1InvalidationFuture.get();
        }
    }

    private Future<Object> invalidateL1(InvocationContext ctx, DataWriteCommand command, boolean assumeOriginKeptEntryInL1) {
        Future l1InvalidationFuture = null;
        if (this.cdl.localNodeIsOwner(command.getKey())) {
            l1InvalidationFuture = this.l1Manager.flushCache(Collections.singletonList(command.getKey()), ctx.getOrigin(), assumeOriginKeptEntryInL1);
        } else {
            log.tracef("Not invalidating key '%' as local node(%s) is not owner", command.getKey(), (Object)this.rpcManager.getAddress());
        }
        return l1InvalidationFuture;
    }

    private void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
    }
}

