/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolderImpl;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.opendaylight.controller.config.persist.api.StorageAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageAdapter
implements StorageAdapter,
Persister {
    private static final Logger logger = LoggerFactory.getLogger(FileStorageAdapter.class);
    private static final Charset ENCODING = Charsets.UTF_8;
    public static final String FILE_STORAGE_PROP = "fileStorage";
    public static final String NUMBER_OF_BACKUPS = "numberOfBackups";
    private static final String SEPARATOR_E_PURE = "//END OF CONFIG";
    private static final String SEPARATOR_E = FileStorageAdapter.newLine("//END OF CONFIG");
    private static final String SEPARATOR_M_PURE = "//END OF SNAPSHOT";
    private static final String SEPARATOR_M = FileStorageAdapter.newLine("//END OF SNAPSHOT");
    private static final String SEPARATOR_S = FileStorageAdapter.newLine("//START OF CONFIG");
    private static final String SEPARATOR_SL_PURE = "//START OF CONFIG-LAST";
    private static final String SEPARATOR_SL = FileStorageAdapter.newLine("//START OF CONFIG-LAST");
    private static Integer numberOfStoredBackups;
    private File storage;

    public Persister instantiate(PropertiesProvider propertiesProvider) {
        File storage = FileStorageAdapter.extractStorageFileFromProperties(propertiesProvider);
        logger.debug("Using file {}", (Object)storage.getAbsolutePath());
        File parentFile = storage.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            logger.debug("Creating parent folders {}", (Object)parentFile);
            parentFile.mkdirs();
        }
        if (!storage.exists()) {
            logger.debug("Storage file does not exist, creating empty file");
            try {
                boolean result = storage.createNewFile();
                if (!result) {
                    throw new RuntimeException("Unable to create storage file " + storage);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create storage file " + storage, e);
            }
        }
        if (numberOfStoredBackups == 0) {
            throw new RuntimeException("numberOfBackups property should be either set to positive value, or ommited. Can not be set to 0.");
        }
        this.setFileStorage(storage);
        return this;
    }

    @VisibleForTesting
    void setFileStorage(File storage) {
        this.storage = storage;
    }

    @VisibleForTesting
    void setNumberOfBackups(Integer numberOfBackups) {
        numberOfStoredBackups = numberOfBackups;
    }

    private static File extractStorageFileFromProperties(PropertiesProvider propertiesProvider) {
        String fileStorageProperty = propertiesProvider.getProperty(FILE_STORAGE_PROP);
        Preconditions.checkNotNull((Object)fileStorageProperty, (Object)("Unable to find " + propertiesProvider.getFullKeyForReporting(FILE_STORAGE_PROP)));
        File result = new File(fileStorageProperty);
        String numberOfBAckupsAsString = propertiesProvider.getProperty(NUMBER_OF_BACKUPS);
        numberOfStoredBackups = numberOfBAckupsAsString != null ? Integer.valueOf(numberOfBAckupsAsString) : Integer.valueOf(Integer.MAX_VALUE);
        logger.trace("Property {} set to {}", (Object)NUMBER_OF_BACKUPS, (Object)numberOfStoredBackups);
        return result;
    }

    private static String newLine(String string) {
        return string + "\n";
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        Preconditions.checkNotNull((Object)this.storage, (Object)"Storage file is null");
        String content = Files.toString((File)this.storage, (Charset)ENCODING);
        if (numberOfStoredBackups == Integer.MAX_VALUE) {
            this.resetLastConfig(content);
            this.persistLastConfig(holder);
        } else if (numberOfStoredBackups == 1) {
            Files.write((CharSequence)"", (File)this.storage, (Charset)ENCODING);
            this.persistLastConfig(holder);
        } else {
            int count = StringUtils.countMatches((CharSequence)content, (CharSequence)SEPARATOR_S);
            if (count + 1 < numberOfStoredBackups) {
                this.resetLastConfig(content);
                this.persistLastConfig(holder);
            } else {
                String contentSubString = StringUtils.substringBefore((String)content, (String)SEPARATOR_E);
                contentSubString = contentSubString.concat(SEPARATOR_E_PURE);
                content = StringUtils.substringAfter((String)content, (String)contentSubString);
                this.resetLastConfig(content);
                this.persistLastConfig(holder);
            }
        }
    }

    private void resetLastConfig(String content) throws IOException {
        content = content.replaceFirst(SEPARATOR_SL, SEPARATOR_S);
        Files.write((CharSequence)content, (File)this.storage, (Charset)ENCODING);
    }

    private void persistLastConfig(ConfigSnapshotHolder holder) throws IOException {
        Files.append((CharSequence)SEPARATOR_SL, (File)this.storage, (Charset)ENCODING);
        String snapshotAsString = holder.getConfigSnapshot();
        Files.append((CharSequence)FileStorageAdapter.newLine(snapshotAsString), (File)this.storage, (Charset)ENCODING);
        Files.append((CharSequence)SEPARATOR_M, (File)this.storage, (Charset)ENCODING);
        Files.append((CharSequence)this.toStringCaps(holder.getCapabilities()), (File)this.storage, (Charset)ENCODING);
        Files.append((CharSequence)SEPARATOR_E, (File)this.storage, (Charset)ENCODING);
    }

    private CharSequence toStringCaps(Set<String> capabilities) {
        StringBuilder b = new StringBuilder();
        for (String capability : capabilities) {
            b.append(FileStorageAdapter.newLine(capability));
        }
        return b.toString();
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        Preconditions.checkNotNull((Object)this.storage, (Object)"Storage file is null");
        if (!this.storage.exists()) {
            return Collections.emptyList();
        }
        LineProcessor lineProcessor = new LineProcessor();
        Files.readLines((File)this.storage, (Charset)ENCODING, (com.google.common.io.LineProcessor)lineProcessor);
        if (!lineProcessor.getConfigSnapshot().isPresent()) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ConfigSnapshotHolderImpl((String)lineProcessor.getConfigSnapshot().get(), lineProcessor.getCapabilities(), this.storage.getAbsolutePath()));
    }

    public void close() {
    }

    public String toString() {
        return "FileStorageAdapter [storage=" + this.storage + "]";
    }

    private static final class LineProcessor
    implements com.google.common.io.LineProcessor<String> {
        private boolean inLastConfig;
        private boolean inLastSnapshot;
        private final StringBuffer snapshotBuffer = new StringBuffer();
        private final SortedSet<String> caps = new TreeSet<String>();

        private LineProcessor() {
        }

        public String getResult() {
            return null;
        }

        public boolean processLine(String line) throws IOException {
            if (this.inLastConfig && line.equals(FileStorageAdapter.SEPARATOR_E_PURE)) {
                this.inLastConfig = false;
                return false;
            }
            if (this.inLastConfig && line.equals(FileStorageAdapter.SEPARATOR_M_PURE)) {
                this.inLastSnapshot = false;
                return true;
            }
            if (this.inLastConfig) {
                if (this.inLastSnapshot) {
                    this.snapshotBuffer.append(line);
                    this.snapshotBuffer.append(System.lineSeparator());
                } else {
                    this.caps.add(line);
                }
            }
            if (line.equals(FileStorageAdapter.SEPARATOR_SL_PURE)) {
                this.inLastConfig = true;
                this.inLastSnapshot = true;
            }
            return true;
        }

        Optional<String> getConfigSnapshot() {
            String xmlContent = this.snapshotBuffer.toString();
            if (xmlContent.equals("")) {
                return Optional.absent();
            }
            return Optional.of((Object)xmlContent);
        }

        SortedSet<String> getCapabilities() {
            return this.caps;
        }
    }
}

