/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.appauth.authorization.Authorization;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.containermanager.ContainerChangeEvent;
import org.opendaylight.controller.containermanager.ContainerConfig;
import org.opendaylight.controller.containermanager.ContainerData;
import org.opendaylight.controller.containermanager.ContainerFlowChangeEvent;
import org.opendaylight.controller.containermanager.ContainerFlowConfig;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.containermanager.NodeConnectorsChangeEvent;
import org.opendaylight.controller.containermanager.internal.IContainerInternal;
import org.opendaylight.controller.sal.authorization.AppRoleLevel;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.Resource;
import org.opendaylight.controller.sal.authorization.ResourceGroup;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.IContainerLocalListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager
extends Authorization<String>
implements IContainerManager,
IObjectReader,
CommandProvider,
ICacheUpdateAware<String, Object>,
IContainerInternal,
IContainerAuthorization,
IConfigurationAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerManager.class);
    private static String CONTAINERS_FILE_NAME = "containers.conf";
    private static final String allContainersGroup = "allContainers";
    private IClusterGlobalServices clusterServices;
    private IConfigurationService configurationService;
    private ConcurrentMap<String, ContainerConfig> containerConfigs;
    private ConcurrentMap<String, ContainerData> containerData;
    private ConcurrentMap<NodeConnector, CopyOnWriteArrayList<String>> nodeConnectorToContainers;
    private ConcurrentMap<Node, Set<String>> nodeToContainers;
    private ConcurrentMap<String, Object> containerChangeEvents;
    private final Set<IContainerAware> iContainerAware = Collections.synchronizedSet(new HashSet());
    private final Set<IContainerListener> iContainerListener = Collections.synchronizedSet(new HashSet());
    private final Set<IContainerLocalListener> iContainerLocalListener = Collections.synchronizedSet(new HashSet());

    void setIContainerListener(IContainerListener s) {
        if (this.iContainerListener != null) {
            this.iContainerListener.add(s);
            if (!this.containerData.isEmpty()) {
                s.containerModeUpdated(UpdateType.ADDED);
            }
            for (Map.Entry entry : this.nodeConnectorToContainers.entrySet()) {
                NodeConnector port = (NodeConnector)entry.getKey();
                for (String container : (CopyOnWriteArrayList)entry.getValue()) {
                    s.nodeConnectorUpdated(container, port, UpdateType.ADDED);
                }
            }
            for (Map.Entry container : this.containerData.entrySet()) {
                for (ContainerFlow cFlow : ((ContainerData)container.getValue()).getContainerFlowSpecs()) {
                    s.containerFlowUpdated((String)container.getKey(), cFlow, cFlow, UpdateType.ADDED);
                }
            }
        }
    }

    void unsetIContainerListener(IContainerListener s) {
        if (this.iContainerListener != null) {
            this.iContainerListener.remove(s);
        }
    }

    void setIContainerLocalListener(IContainerLocalListener s) {
        if (this.iContainerLocalListener != null) {
            this.iContainerLocalListener.add(s);
        }
    }

    void unsetIContainerLocalListener(IContainerLocalListener s) {
        if (this.iContainerLocalListener != null) {
            this.iContainerLocalListener.remove(s);
        }
    }

    public void setIContainerAware(IContainerAware iContainerAware) {
        if (!this.iContainerAware.contains(iContainerAware)) {
            this.iContainerAware.add(iContainerAware);
            for (String container : this.getContainerNameList()) {
                iContainerAware.containerCreate(container.toLowerCase(Locale.ENGLISH));
            }
        }
    }

    public void unsetIContainerAware(IContainerAware iContainerAware) {
        this.iContainerAware.remove(iContainerAware);
    }

    public void setClusterServices(IClusterGlobalServices i) {
        this.clusterServices = i;
        logger.debug("IClusterServices set");
    }

    public void unsetClusterServices(IClusterGlobalServices i) {
        if (this.clusterServices == i) {
            this.clusterServices = null;
            logger.debug("IClusterServices Unset");
        }
    }

    public void setConfigurationService(IConfigurationService service) {
        logger.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationService(IConfigurationService service) {
        logger.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    private void allocateCaches() {
        logger.debug("Container Manager allocating caches");
        if (this.clusterServices == null) {
            logger.warn("un-initialized Cluster Services, can't allocate caches");
            return;
        }
        try {
            this.clusterServices.createCache("containermgr.containerConfigs", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.event.containerChange", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.containerData", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.nodeConnectorToContainers", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.nodeToContainers", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.containerGroups", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.containerAuthorizations", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterServices.createCache("containermgr.roles", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache configuration invalid - check cache mode");
        }
        catch (CacheExistException ce) {
            logger.error("Cache already exits - destroy and recreate if needed");
        }
    }

    private void retrieveCaches() {
        logger.debug("Container Manager retrieving caches");
        if (this.clusterServices == null) {
            logger.warn("un-initialized Cluster Services, can't retrieve caches");
            return;
        }
        this.containerConfigs = this.clusterServices.getCache("containermgr.containerConfigs");
        this.containerChangeEvents = this.clusterServices.getCache("containermgr.event.containerChange");
        this.containerData = this.clusterServices.getCache("containermgr.containerData");
        this.nodeConnectorToContainers = this.clusterServices.getCache("containermgr.nodeConnectorToContainers");
        this.nodeToContainers = this.clusterServices.getCache("containermgr.nodeToContainers");
        this.resourceGroups = this.clusterServices.getCache("containermgr.containerGroups");
        this.groupsAuthorizations = this.clusterServices.getCache("containermgr.containerAuthorizations");
        this.roles = this.clusterServices.getCache("containermgr.roles");
        if (this.inContainerMode()) {
            for (Map.Entry entry : this.containerConfigs.entrySet()) {
                this.notifyContainerChangeInternal((ContainerConfig)entry.getValue(), UpdateType.ADDED, true);
            }
        }
    }

    public void entryCreated(String containerName, String cacheName, boolean originLocal) {
    }

    public void entryUpdated(String key, Object value, String cacheName, boolean originLocal) {
        if (!originLocal) {
            if (value instanceof NodeConnectorsChangeEvent) {
                NodeConnectorsChangeEvent event = (NodeConnectorsChangeEvent)value;
                List ncList = event.getNodeConnectors();
                this.notifyContainerEntryChangeInternal(key, ncList, event.getUpdateType(), false);
            } else if (value instanceof ContainerFlowChangeEvent) {
                ContainerFlowChangeEvent event = (ContainerFlowChangeEvent)value;
                this.notifyCFlowChangeInternal(key, event.getConfigList(), event.getUpdateType(), false);
            } else if (value instanceof ContainerChangeEvent) {
                ContainerChangeEvent event = (ContainerChangeEvent)value;
                this.notifyContainerChangeInternal(event.getConfig(), event.getUpdateType(), false);
            }
        }
    }

    public void entryDeleted(String containerName, String cacheName, boolean originLocal) {
    }

    public void init() {
    }

    public void start() {
        this.allocateCaches();
        this.retrieveCaches();
        this.createDefaultAuthorizationGroups();
        this.loadContainerConfig();
    }

    public void destroy() {
        this.iContainerAware.clear();
        this.iContainerListener.clear();
        this.iContainerLocalListener.clear();
    }

    private Status updateContainerFlow(String containerName, List<ContainerFlowConfig> confList, boolean delete) {
        ContainerData container = this.getContainerByName(containerName);
        if (container == null) {
            return new Status(StatusCode.GONE, "Container not present");
        }
        for (ContainerFlowConfig conf : confList) {
            for (Match match : conf.getMatches()) {
                ContainerFlow cFlow = new ContainerFlow(match);
                if (delete) {
                    logger.trace("Removing Flow Spec {} from Container {}", (Object)conf.getName(), (Object)containerName);
                    container.deleteFlowSpec(cFlow);
                } else {
                    logger.trace("Adding Flow Spec {} to Container {}", (Object)conf.getName(), (Object)containerName);
                    container.addFlowSpec(cFlow);
                }
                this.putContainerDataByName(containerName, container);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status updateContainerDatabase(ContainerConfig containerConf, boolean delete) {
        String containerName = containerConf.getContainerName();
        ContainerData container = this.getContainerByName(containerName);
        if (delete && container == null) {
            return new Status(StatusCode.NOTFOUND, "Container is not present");
        }
        if (!delete && container != null) {
            return new Status(StatusCode.CONFLICT, "A container with the same name already exists");
        }
        if (delete) {
            logger.debug("Removing container {}", (Object)containerName);
            this.removeNodeToContainersMapping(container);
            this.removeNodeConnectorToContainersMapping(container);
            this.removeContainerDataByName(containerName);
        } else {
            logger.debug("Adding container {}", (Object)containerName);
            container = new ContainerData(containerConf);
            this.putContainerDataByName(containerName, container);
            if (containerConf.hasFlowSpecs()) {
                this.updateContainerFlow(containerName, containerConf.getContainerFlowConfigs(), delete);
            }
            if (!containerConf.getPortList().isEmpty()) {
                this.updateContainerEntryDatabase(containerName, containerConf.getPortList(), delete);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private void removeNodeConnectorToContainersMapping(ContainerData container) {
        Iterator it = this.nodeConnectorToContainers.entrySet().iterator();
        String containerName = container.getContainerName();
        block0: while (it.hasNext()) {
            Map.Entry entry = it.next();
            NodeConnector nc = (NodeConnector)entry.getKey();
            CopyOnWriteArrayList slist = (CopyOnWriteArrayList)entry.getValue();
            for (String sdata : slist) {
                if (!sdata.equalsIgnoreCase(containerName)) continue;
                logger.debug("Removing NodeConnector->Containers mapping, nodeConnector: {}", (Object)nc);
                slist.remove(containerName);
                if (slist.isEmpty()) {
                    this.nodeConnectorToContainers.remove(nc);
                    continue block0;
                }
                this.nodeConnectorToContainers.put(nc, slist);
                continue block0;
            }
        }
    }

    private void removeNodeToContainersMapping(ContainerData container) {
        block0: for (Map.Entry entry : this.nodeToContainers.entrySet()) {
            Node node = (Node)entry.getKey();
            for (String sdata : (Set)entry.getValue()) {
                if (!sdata.equals(container.getContainerName())) continue;
                logger.debug("Removing Node->Containers mapping, node {} container {}", (Object)node, (Object)sdata);
                Set value = (Set)this.nodeToContainers.get(node);
                value.remove(sdata);
                this.nodeToContainers.put(node, value);
                continue block0;
            }
        }
    }

    private Status updateContainerEntryDatabase(String containerName, List<NodeConnector> nodeConnectors, boolean delete) {
        ContainerData container = this.getContainerByName(containerName);
        if (container == null) {
            return new Status(StatusCode.NOTFOUND, "Container Not Found");
        }
        for (NodeConnector port : nodeConnectors) {
            Collection slist;
            Node node = port.getNode();
            if (delete) {
                container.removePortFromSwitch(port);
                this.putContainerDataByName(containerName, container);
                if (this.nodeConnectorToContainers.containsKey(port)) {
                    this.nodeConnectorToContainers.remove(port);
                }
                if (!container.portListEmpty(node)) continue;
                logger.debug("Port List empty for switch {}", (Object)node);
                this.putContainerDataByName(containerName, container);
                slist = (Set)this.nodeToContainers.get(node);
                if (slist == null) continue;
                logger.debug("Removing container from switch-container list. node{}, container{}", (Object)node, (Object)containerName);
                slist.remove(container.getContainerName());
                this.nodeToContainers.put(node, (Set<String>)slist);
                if (!slist.isEmpty()) continue;
                logger.debug("Container list empty for switch {}. removing switch-container mapping", (Object)node);
                this.nodeToContainers.remove(node);
                continue;
            }
            if (!container.isSwitchInContainer(node)) {
                HashSet<String> value = (HashSet<String>)this.nodeToContainers.get(node);
                if (value == null) {
                    value = new HashSet<String>();
                    logger.debug("Creating new Container Set for switch {}", (Object)node);
                }
                value.add(container.getContainerName());
                this.nodeToContainers.put(node, value);
            }
            container.addPortToSwitch(port);
            this.putContainerDataByName(containerName, container);
            slist = (CopyOnWriteArrayList<String>)this.nodeConnectorToContainers.get(port);
            if (slist == null) {
                slist = new CopyOnWriteArrayList<String>();
            }
            ((CopyOnWriteArrayList)slist).add(container.getContainerName());
            this.nodeConnectorToContainers.put(port, (CopyOnWriteArrayList<String>)slist);
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateContainerFlowAddRemoval(String containerName, ContainerFlow cFlow, boolean delete) {
        ContainerData container = this.getContainerByName(containerName);
        if (container == null) {
            String error = String.format("Cannot validate flow specs for container %s: (Container does not exist)", containerName);
            logger.warn(error);
            return new Status(StatusCode.BADREQUEST, error);
        }
        if (delete) {
            Set thisContainerPorts = container.getNodeConnectors();
            for (Map.Entry entry : this.containerData.entrySet()) {
                if (containerName.equalsIgnoreCase((String)entry.getKey())) continue;
                Set commonPorts = ((ContainerData)entry.getValue()).getNodeConnectors();
                commonPorts.retainAll(thisContainerPorts);
                if (commonPorts.isEmpty() || container.getFlowSpecCount() != 1) continue;
                if (!container.hasStaticVlanAssigned()) {
                    return new Status(StatusCode.BADREQUEST, "Container shares port with another container: The only one flow spec assigned to this container cannot be removed,because this container is not assigned any static vlan");
                }
                ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)this);
                if (topologyManager == null) {
                    return new Status(StatusCode.NOSERVICE, "Cannot validate the request: Required service is not available");
                }
                for (NodeConnector nc : commonPorts) {
                    if (topologyManager.isInternal(nc)) continue;
                    return new Status(StatusCode.BADREQUEST, String.format("Port %s is shared and is host facing port: The only one flow spec assigned to this container cannot be removed", nc));
                }
            }
        } else {
            Set thisContainerPorts = container.getNodeConnectors();
            ArrayList<ContainerFlow> proposed = new ArrayList<ContainerFlow>(container.getContainerFlowSpecs());
            proposed.add(cFlow);
            for (Map.Entry entry : this.containerData.entrySet()) {
                Status status;
                if (containerName.equalsIgnoreCase((String)entry.getKey())) continue;
                ContainerData otherContainer = (ContainerData)entry.getValue();
                Set commonPorts = otherContainer.getNodeConnectors();
                commonPorts.retainAll(thisContainerPorts);
                if (commonPorts.isEmpty() || (status = this.checkCommonContainerFlow(otherContainer.getContainerFlowSpecs(), proposed)).isSuccess()) continue;
                return new Status(StatusCode.BADREQUEST, String.format("Container %s which shares ports with this container has overlapping flow spec: %s", entry.getKey(), status.getDescription()));
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validatePortSharing(String containerName, List<NodeConnector> portList) {
        ContainerData container = this.getContainerByName(containerName);
        if (container == null) {
            String error = String.format("Cannot validate port sharing for container %s: (container does not exist)", containerName);
            logger.error(error);
            return new Status(StatusCode.BADREQUEST, error);
        }
        return this.validatePortSharingInternal(portList, container.getContainerFlowSpecs());
    }

    private Status validatePortSharing(ContainerConfig containerConf) {
        return this.validatePortSharingInternal(containerConf.getPortList(), containerConf.getContainerFlowSpecs());
    }

    private Status validatePortSharingInternal(List<NodeConnector> portList, List<ContainerFlow> flowSpecList) {
        for (NodeConnector port : portList) {
            List slist = (List)this.nodeConnectorToContainers.get(port);
            if (slist == null || slist.isEmpty()) continue;
            for (String otherContainerName : slist) {
                String msg = null;
                ContainerData other = (ContainerData)this.containerData.get(otherContainerName);
                if (flowSpecList.isEmpty()) {
                    msg = String.format("Port %s is shared and flow spec is empty for this container", port);
                } else if (other.isFlowSpecEmpty()) {
                    msg = String.format("Port %s is shared and flow spec is empty for the other container", port);
                } else if (!this.checkCommonContainerFlow(flowSpecList, other.getContainerFlowSpecs()).isSuccess()) {
                    msg = String.format("Port %s is shared and other container has common flow spec", port);
                }
                if (msg == null) continue;
                logger.debug(msg);
                return new Status(StatusCode.BADREQUEST, msg);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status checkCommonContainerFlow(List<ContainerFlow> oneFlowList, List<ContainerFlow> twoFlowList) {
        for (ContainerFlow oneFlow : oneFlowList) {
            for (ContainerFlow twoFlow : twoFlowList) {
                if (!oneFlow.getMatch().intersetcs(twoFlow.getMatch())) continue;
                return new Status(StatusCode.CONFLICT, String.format("Flow Specs overlap: %s %s", oneFlow.getMatch(), twoFlow.getMatch()));
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private ContainerData getContainerByName(String name) {
        return (ContainerData)this.containerData.get(name.toLowerCase(Locale.ENGLISH));
    }

    private void putContainerDataByName(String name, ContainerData sData) {
        this.containerData.put(name.toLowerCase(Locale.ENGLISH), sData);
    }

    private void removeContainerDataByName(String name) {
        this.containerData.remove(name.toLowerCase(Locale.ENGLISH));
    }

    public List<ContainerConfig> getContainerConfigList() {
        return new ArrayList<ContainerConfig>(this.containerConfigs.values());
    }

    public ContainerConfig getContainerConfig(String containerName) {
        ContainerConfig target = (ContainerConfig)this.containerConfigs.get(containerName);
        return target == null ? null : new ContainerConfig(target);
    }

    public List<String> getContainerNameList() {
        ArrayList<String> containerNameList = new ArrayList<String>();
        containerNameList.add(GlobalConstants.DEFAULT.toString());
        containerNameList.addAll(this.containerConfigs.keySet());
        return containerNameList;
    }

    public Map<String, List<ContainerFlowConfig>> getContainerFlows() {
        HashMap<String, List<ContainerFlowConfig>> flowSpecConfig = new HashMap<String, List<ContainerFlowConfig>>();
        for (Map.Entry entry : this.containerConfigs.entrySet()) {
            List set = ((ContainerConfig)entry.getValue()).getContainerFlowConfigs();
            flowSpecConfig.put((String)entry.getKey(), set);
        }
        return flowSpecConfig;
    }

    private Status saveContainerConfig() {
        return this.saveContainerConfigLocal();
    }

    public Status saveContainerConfigLocal() {
        Status status = this.configurationService.persistConfiguration(new ArrayList(this.containerConfigs.values()), CONTAINERS_FILE_NAME);
        if (!status.isSuccess()) {
            return new Status(StatusCode.INTERNALERROR, "Failed to save container configurations: " + status.getDescription());
        }
        return status;
    }

    private void removeComponentsStartUpfiles(String containerName) {
        String startupLocation = String.format("./%s", GlobalConstants.STARTUPHOME.toString());
        String containerPrint = String.format("_%s.", containerName.toLowerCase(Locale.ENGLISH));
        File directory = new File(startupLocation);
        String[] fileList = directory.list();
        logger.trace("Deleting startup configuration files for container {}", (Object)containerName);
        if (fileList != null) {
            for (String fileName : fileList) {
                if (!fileName.contains(containerPrint)) continue;
                String fullPath = String.format("%s/%s", startupLocation, fileName);
                File file = new File(fullPath);
                boolean done = file.delete();
                logger.trace("{} {}", (Object)(done ? "Deleted: " : "Failed to delete: "), (Object)fileName);
            }
        }
    }

    private void createDefaultAuthorizationGroups() {
        HashSet<String> allContainers;
        this.allResourcesGroupName = allContainersGroup;
        String defaultContainer = GlobalConstants.DEFAULT.toString();
        Set<String> set = allContainers = this.resourceGroups.containsKey(this.allResourcesGroupName) ? (Set)this.resourceGroups.get(this.allResourcesGroupName) : new HashSet<String>();
        if (!allContainers.contains(defaultContainer)) {
            allContainers.add(defaultContainer);
            this.resourceGroups.put(this.allResourcesGroupName, allContainers);
        }
        if (!this.roles.containsKey(UserLevel.SYSTEMADMIN.toString())) {
            this.roles.put(UserLevel.SYSTEMADMIN.toString(), AppRoleLevel.APPADMIN);
        }
        if (!this.roles.containsKey(UserLevel.NETWORKADMIN.toString())) {
            this.roles.put(UserLevel.NETWORKADMIN.toString(), AppRoleLevel.APPADMIN);
        }
        if (!this.roles.containsKey(UserLevel.NETWORKOPERATOR.toString())) {
            this.roles.put(UserLevel.NETWORKOPERATOR.toString(), AppRoleLevel.APPOPERATOR);
        }
        if (!this.groupsAuthorizations.containsKey(UserLevel.NETWORKADMIN.toString())) {
            HashSet<ResourceGroup> writeProfile = new HashSet<ResourceGroup>(1);
            HashSet<ResourceGroup> readProfile = new HashSet<ResourceGroup>(1);
            writeProfile.add(new ResourceGroup(this.allResourcesGroupName, Privilege.WRITE));
            readProfile.add(new ResourceGroup(this.allResourcesGroupName, Privilege.READ));
            this.groupsAuthorizations.put(UserLevel.SYSTEMADMIN.toString(), writeProfile);
            this.groupsAuthorizations.put(UserLevel.NETWORKADMIN.toString(), writeProfile);
            this.groupsAuthorizations.put(UserLevel.NETWORKOPERATOR.toString(), readProfile);
        }
    }

    private void updateResourceGroups(ContainerConfig containerConf, boolean delete) {
        String containerName = containerConf.getContainer();
        String groupName = containerConf.getContainerGroupName();
        String containerAdminRole = containerConf.getContainerAdminRole();
        String containerOperatorRole = containerConf.getContainerOperatorRole();
        Set allContainerSet = (Set)this.resourceGroups.get(this.allResourcesGroupName);
        if (delete) {
            this.resourceGroups.remove(groupName);
            this.groupsAuthorizations.remove(containerAdminRole);
            this.groupsAuthorizations.remove(containerOperatorRole);
            this.roles.remove(containerAdminRole);
            this.roles.remove(containerOperatorRole);
            allContainerSet.remove(containerName);
        } else {
            HashSet<String> resources = new HashSet<String>(1);
            resources.add(containerName);
            this.resourceGroups.put(groupName, resources);
            HashSet<ResourceGroup> adminGroups = new HashSet<ResourceGroup>(1);
            HashSet<ResourceGroup> operatorGroups = new HashSet<ResourceGroup>(1);
            adminGroups.add(new ResourceGroup(groupName, Privilege.WRITE));
            operatorGroups.add(new ResourceGroup(groupName, Privilege.READ));
            this.groupsAuthorizations.put(containerAdminRole, adminGroups);
            this.groupsAuthorizations.put(containerOperatorRole, operatorGroups);
            this.roles.put(containerAdminRole, AppRoleLevel.APPADMIN);
            this.roles.put(containerOperatorRole, AppRoleLevel.APPOPERATOR);
            allContainerSet.add(containerName);
        }
        this.resourceGroups.put(this.allResourcesGroupName, allContainerSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContainerAwareListeners(String containerName, boolean delete) {
        String name = containerName.toLowerCase(Locale.ENGLISH);
        Set<IContainerAware> set = this.iContainerAware;
        synchronized (set) {
            for (IContainerAware i : this.iContainerAware) {
                if (delete) {
                    i.containerDestroy(name);
                    continue;
                }
                i.containerCreate(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContainerModeChange(boolean lastActionDelete, boolean notifyLocal) {
        if (!lastActionDelete && this.containerConfigs.size() == 1) {
            logger.trace("First container Creation. Inform listeners");
            Set<IContainerListener> set = this.iContainerListener;
            synchronized (set) {
                for (IContainerListener iContainerListener : this.iContainerListener) {
                    iContainerListener.containerModeUpdated(UpdateType.ADDED);
                }
            }
            if (notifyLocal) {
                set = this.iContainerLocalListener;
                synchronized (set) {
                    for (IContainerLocalListener iContainerLocalListener : this.iContainerLocalListener) {
                        iContainerLocalListener.containerModeUpdated(UpdateType.ADDED);
                    }
                }
            }
        } else if (lastActionDelete && this.containerConfigs.isEmpty()) {
            logger.trace("Last container Deletion. Inform listeners");
            Set<IContainerListener> set = this.iContainerListener;
            synchronized (set) {
                for (IContainerListener iContainerListener : this.iContainerListener) {
                    iContainerListener.containerModeUpdated(UpdateType.REMOVED);
                }
            }
            if (notifyLocal) {
                set = this.iContainerLocalListener;
                synchronized (set) {
                    for (IContainerLocalListener iContainerLocalListener : this.iContainerLocalListener) {
                        iContainerLocalListener.containerModeUpdated(UpdateType.REMOVED);
                    }
                }
            }
        }
    }

    private Status addRemoveContainerEntries(String containerName, List<String> nodeConnectorsString, boolean delete) {
        String action = String.format("Node connector(s) %s container %s: %s", delete ? "removal from" : "addition to", containerName, nodeConnectorsString);
        if (nodeConnectorsString == null || nodeConnectorsString.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Node connector list is null or empty");
        }
        ContainerConfig entryConf = (ContainerConfig)this.containerConfigs.get(containerName);
        if (entryConf == null) {
            String msg = String.format("Container not found: %s", containerName);
            String error = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error);
            return new Status(StatusCode.NOTFOUND, msg);
        }
        Status status = ContainerConfig.validateNodeConnectors(nodeConnectorsString);
        if (!status.isSuccess()) {
            String error = String.format("Failed to apply %s: (%s)", action, status.getDescription());
            logger.warn(error);
            return status;
        }
        List nodeConnectors = ContainerConfig.nodeConnectorsFromString(nodeConnectorsString);
        if (!delete && !(status = this.validatePortSharing(containerName, nodeConnectors)).isSuccess()) {
            String error = String.format("Failed to apply %s: (%s)", action, status.getDescription());
            logger.warn(error);
            return status;
        }
        status = this.updateContainerEntryDatabase(containerName, nodeConnectors, delete);
        if (!status.isSuccess()) {
            String error = String.format("Failed to apply %s: (%s)", action, status.getDescription());
            logger.warn(error);
            return status;
        }
        Status status2 = status = delete ? entryConf.removeNodeConnectors(nodeConnectorsString) : entryConf.addNodeConnectors(nodeConnectorsString);
        if (!status.isSuccess()) {
            String error = String.format("Failed to modify config for %s: (%s)", action, status.getDescription());
            logger.warn(error);
            Status statusRevert = this.updateContainerEntryDatabase(containerName, nodeConnectors, !delete);
            if (!statusRevert.isSuccess()) {
                logger.error("Failed to revert changes in database (CRITICAL)");
            }
            return status;
        }
        this.containerConfigs.put(containerName, entryConf);
        UpdateType update = delete ? UpdateType.REMOVED : UpdateType.ADDED;
        this.notifyContainerEntryChangeInternal(containerName, nodeConnectors, update, true);
        this.containerChangeEvents.put(containerName, new NodeConnectorsChangeEvent(nodeConnectors, update));
        return status;
    }

    private void notifyContainerChangeInternal(ContainerConfig conf, UpdateType update, boolean notifyLocal) {
        String containerName = conf.getContainerName();
        logger.trace("Notifying listeners on {} for container {}", (Object)update, (Object)containerName);
        String container = containerName.toLowerCase(Locale.ENGLISH);
        boolean delete = update == UpdateType.REMOVED;
        this.notifyContainerModeChange(delete, notifyLocal);
        this.notifyContainerAwareListeners(container, delete);
        if (delete) {
            this.removeComponentsStartUpfiles(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyContainerEntryChangeInternal(String containerName, List<NodeConnector> ncList, UpdateType update, boolean notifyLocal) {
        logger.trace("Notifying listeners on {} for ports {} in container {}", new Object[]{update, ncList, containerName});
        String container = containerName.toLowerCase(Locale.ENGLISH);
        for (NodeConnector nodeConnector : ncList) {
            Set<IContainerListener> set = this.iContainerListener;
            synchronized (set) {
                for (IContainerListener iContainerListener : this.iContainerListener) {
                    iContainerListener.nodeConnectorUpdated(container, nodeConnector, update);
                }
            }
            if (!notifyLocal) continue;
            set = this.iContainerLocalListener;
            synchronized (set) {
                for (IContainerLocalListener iContainerLocalListener : this.iContainerLocalListener) {
                    iContainerLocalListener.nodeConnectorUpdated(container, nodeConnector, update);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCFlowChangeInternal(String containerName, List<ContainerFlowConfig> confList, UpdateType update, boolean notifyLocal) {
        logger.trace("Notifying listeners on {} for flow specs {} in container {}", new Object[]{update, confList, containerName});
        String container = containerName.toLowerCase(Locale.ENGLISH);
        for (ContainerFlowConfig conf : confList) {
            for (Match match : conf.getMatches()) {
                ContainerFlow cFlow = new ContainerFlow(match);
                Set<IContainerListener> set = this.iContainerListener;
                synchronized (set) {
                    for (IContainerListener iContainerListener : this.iContainerListener) {
                        iContainerListener.containerFlowUpdated(container, cFlow, cFlow, update);
                    }
                }
                if (!notifyLocal) continue;
                set = this.iContainerLocalListener;
                synchronized (set) {
                    for (IContainerLocalListener iContainerLocalListener : this.iContainerLocalListener) {
                        iContainerLocalListener.containerFlowUpdated(container, cFlow, cFlow, update);
                    }
                }
            }
        }
    }

    private Status addRemoveContainerFlow(String containerName, List<ContainerFlowConfig> cFlowConfList, boolean delete) {
        String error;
        String action = String.format("Flow spec(s) %s container %s: %s", delete ? "removal from" : "addition to", containerName, cFlowConfList);
        ContainerConfig containerConfig = (ContainerConfig)this.containerConfigs.get(containerName);
        if (containerConfig == null) {
            String msg = String.format("Container not found: %s", containerName);
            String error2 = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error2);
            return new Status(StatusCode.NOTFOUND, "Container not present");
        }
        Status status = containerConfig.validateContainerFlowModify(cFlowConfList, delete);
        if (!status.isSuccess()) {
            String msg = status.getDescription();
            String error3 = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error3);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        for (ContainerFlowConfig conf : cFlowConfList) {
            for (Match match : conf.getMatches()) {
                ContainerFlow cFlow = new ContainerFlow(match);
                status = this.validateContainerFlowAddRemoval(containerName, cFlow, delete);
                if (status.isSuccess()) continue;
                String msg = "Validation failed: " + status.getDescription();
                String error4 = String.format("Failed to apply %s: (%s)", action, msg);
                logger.warn(error4);
                return new Status(StatusCode.BADREQUEST, msg);
            }
        }
        status = this.updateContainerFlow(containerName, cFlowConfList, delete);
        if (!status.isSuccess()) {
            error = String.format("Failed to apply %s: (%s)", action, status.getDescription());
            logger.error(error);
            return status;
        }
        Status status2 = status = delete ? containerConfig.removeContainerFlows(cFlowConfList) : containerConfig.addContainerFlows(cFlowConfList);
        if (!status.isSuccess()) {
            error = String.format("Failed to modify config for %s: (%s)", action, status.getDescription());
            logger.error(error);
            Status statusRevert = this.updateContainerFlow(containerName, cFlowConfList, !delete);
            if (!statusRevert.isSuccess()) {
                logger.error("Failed to revert changes in database (CRITICAL)");
            }
            return status;
        }
        this.containerConfigs.put(containerName, containerConfig);
        UpdateType update = delete ? UpdateType.REMOVED : UpdateType.ADDED;
        this.notifyCFlowChangeInternal(containerName, cFlowConfList, update, true);
        this.containerChangeEvents.put(containerName, new ContainerFlowChangeEvent(cFlowConfList, update));
        return status;
    }

    private Status addRemoveContainer(ContainerConfig containerConf, boolean delete) {
        String error;
        String action = String.format("Container %s", delete ? "removal" : "creation");
        Status status = null;
        String string = this.containerConfigs == null ? String.format("Invalid %s configuration: (null config object)", action) : (error = !(status = containerConf.validate()).isSuccess() ? String.format("Invalid %s configuration: (%s)", action, status.getDescription()) : null);
        if (error != null) {
            logger.warn(error);
            return new Status(StatusCode.BADREQUEST, error);
        }
        String containerName = containerConf.getContainerName();
        if (delete) {
            if (!this.containerConfigs.containsKey(containerName)) {
                String msg = String.format("%s Failed: (Container does not exist: %s)", action, containerName);
                logger.warn(msg);
                return new Status(StatusCode.NOTFOUND, msg);
            }
        } else if (this.containerConfigs.containsKey(containerName)) {
            String msg = String.format("%s Failed: (Container already exist: %s)", action, containerName);
            logger.warn(msg);
            return new Status(StatusCode.CONFLICT, msg);
        }
        if (!delete && !(status = this.validatePortSharing(containerConf)).isSuccess()) {
            error = String.format("%s Failed: (%s)", action, status.getDescription());
            logger.error(error);
            return status;
        }
        status = this.updateContainerDatabase(containerConf, delete);
        if (!status.isSuccess()) {
            return status;
        }
        if (delete) {
            this.containerConfigs.remove(containerName);
        } else {
            this.containerConfigs.put(containerName, containerConf);
        }
        this.updateResourceGroups(containerConf, delete);
        UpdateType update = delete ? UpdateType.REMOVED : UpdateType.ADDED;
        this.notifyContainerChangeInternal(containerConf, update, true);
        this.containerChangeEvents.put(containerName, new ContainerChangeEvent(containerConf, update));
        if (update == UpdateType.ADDED) {
            if (containerConf.hasFlowSpecs()) {
                List specList = containerConf.getContainerFlowConfigs();
                this.notifyCFlowChangeInternal(containerName, specList, update, true);
                this.containerChangeEvents.put(containerName, new ContainerFlowChangeEvent(specList, update));
            }
            if (containerConf.hasNodeConnectors()) {
                List ncList = containerConf.getPortList();
                this.notifyContainerEntryChangeInternal(containerName, ncList, update, true);
                this.containerChangeEvents.put(containerName, new NodeConnectorsChangeEvent(ncList, update));
            }
        }
        if (delete) {
            this.clusterServices.removeContainerCaches(containerName);
        }
        return status;
    }

    public Status addContainer(ContainerConfig containerConf) {
        return this.addRemoveContainer(containerConf, false);
    }

    public Status removeContainer(ContainerConfig containerConf) {
        return this.addRemoveContainer(containerConf, true);
    }

    public Status removeContainer(String containerName) {
        String action = String.format("Container removal: %s", containerName);
        ContainerConfig containerConf = (ContainerConfig)this.containerConfigs.get(containerName);
        if (containerConf == null) {
            String msg = String.format("Container not found", new Object[0]);
            String error = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error);
            return new Status(StatusCode.NOTFOUND, msg);
        }
        return this.addRemoveContainer(containerConf, true);
    }

    public Status addContainerEntry(String containerName, List<String> nodeConnectors) {
        return this.addRemoveContainerEntries(containerName, nodeConnectors, false);
    }

    public Status removeContainerEntry(String containerName, List<String> nodeConnectors) {
        return this.addRemoveContainerEntries(containerName, nodeConnectors, true);
    }

    public Status addContainerFlows(String containerName, List<ContainerFlowConfig> fSpecConf) {
        return this.addRemoveContainerFlow(containerName, fSpecConf, false);
    }

    public Status removeContainerFlows(String containerName, List<ContainerFlowConfig> fSpecConf) {
        return this.addRemoveContainerFlow(containerName, fSpecConf, true);
    }

    public Status removeContainerFlows(String containerName, Set<String> names) {
        String action = String.format("Flow spec(s) removal from container %s: %s", containerName, names);
        ContainerConfig sc = (ContainerConfig)this.containerConfigs.get(containerName);
        if (sc == null) {
            String msg = String.format("Container not found: %s", containerName);
            String error = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error);
            return new Status(StatusCode.NOTFOUND, msg);
        }
        List list = sc.getContainerFlowConfigs(names);
        if (list.isEmpty() || list.size() != names.size()) {
            String msg = String.format("Cannot find all the specified flow specs", new Object[0]);
            String error = String.format("Failed to apply %s: (%s)", action, msg);
            logger.warn(error);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        return this.addRemoveContainerFlow(containerName, list, true);
    }

    public List<ContainerFlowConfig> getContainerFlows(String containerName) {
        ContainerConfig sc = (ContainerConfig)this.containerConfigs.get(containerName);
        return sc == null ? new ArrayList(0) : sc.getContainerFlowConfigs();
    }

    public List<String> getContainerFlowNameList(String containerName) {
        ContainerConfig sc = (ContainerConfig)this.containerConfigs.get(containerName);
        return sc == null ? new ArrayList(0) : sc.getContainerFlowConfigsNames();
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    private void loadContainerConfig() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, CONTAINERS_FILE_NAME)) {
            this.addContainer((ContainerConfig)conf);
        }
    }

    public void _psc(CommandInterpreter ci) {
        for (Map.Entry entry : this.containerConfigs.entrySet()) {
            ContainerConfig sc = (ContainerConfig)entry.getValue();
            ci.println((Object)String.format("%s: %s", sc.getContainerName(), sc.toString()));
        }
        ci.println((Object)("Total number of containers: " + this.containerConfigs.entrySet().size()));
    }

    public void _pfc(CommandInterpreter ci) {
        for (Map.Entry entry : this.containerConfigs.entrySet()) {
            ContainerConfig sc = (ContainerConfig)entry.getValue();
            ci.println((Object)String.format("%s: %s", sc.getContainerName(), sc.getContainerFlowConfigs()));
        }
    }

    public void _psd(CommandInterpreter ci) {
        for (String containerName : this.containerData.keySet()) {
            ContainerData sd = (ContainerData)this.containerData.get(containerName);
            for (Node sid : sd.getSwPorts().keySet()) {
                Set s = (Set)sd.getSwPorts().get(sid);
                ci.println((Object)("\t" + sid + " : " + s));
            }
            for (ContainerFlow s : sd.getContainerFlowSpecs()) {
                ci.println((Object)("\t" + s.toString()));
            }
        }
    }

    public void _psp(CommandInterpreter ci) {
        for (NodeConnector sp : this.nodeConnectorToContainers.keySet()) {
            ci.println(this.nodeConnectorToContainers.get(sp));
        }
    }

    public void _psm(CommandInterpreter ci) {
        for (Node sp : this.nodeToContainers.keySet()) {
            ci.println(this.nodeToContainers.get(sp));
        }
    }

    public void _addContainer(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String staticVlan = ci.nextArgument();
        ContainerConfig containerConfig = new ContainerConfig(containerName, staticVlan, null, null);
        ci.println((Object)this.addRemoveContainer(containerConfig, false));
    }

    public void _createContainer(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String staticVlan = ci.nextArgument();
        if (staticVlan == null) {
            ci.print((Object)"Static Vlan not specified");
            return;
        }
        ArrayList<String> ports = new ArrayList<String>();
        for (long l = 1L; l < 10L; ++l) {
            ports.add(NodeConnectorCreator.createOFNodeConnector((Short)1, (Node)NodeCreator.createOFNode((Long)l)).toString());
        }
        ArrayList<ContainerFlowConfig> cFlowList = new ArrayList<ContainerFlowConfig>();
        cFlowList.add(this.createSampleContainerFlowConfig("tcp", true));
        ContainerConfig containerConfig = new ContainerConfig(containerName, staticVlan, ports, cFlowList);
        ci.println((Object)this.addRemoveContainer(containerConfig, false));
    }

    public void _removeContainer(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        ContainerConfig containerConfig = new ContainerConfig(containerName, "", null, null);
        ci.println((Object)this.addRemoveContainer(containerConfig, true));
    }

    public void _addContainerEntry(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node Id not specified");
            return;
        }
        String portId = ci.nextArgument();
        if (portId == null) {
            ci.print((Object)"Port not specified");
            return;
        }
        Node node = NodeCreator.createOFNode((Long)Long.valueOf(nodeId));
        Short port = Short.valueOf(portId);
        NodeConnector nc = NodeConnectorCreator.createOFNodeConnector((Short)port, (Node)node);
        ArrayList<String> portList = new ArrayList<String>(1);
        portList.add(nc.toString());
        ci.println((Object)this.addRemoveContainerEntries(containerName, portList, false));
    }

    public void _removeContainerEntry(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node Id not specified");
            return;
        }
        String portId = ci.nextArgument();
        if (portId == null) {
            ci.print((Object)"Port not specified");
            return;
        }
        Node node = NodeCreator.createOFNode((Long)Long.valueOf(nodeId));
        Short port = Short.valueOf(portId);
        NodeConnector nc = NodeConnectorCreator.createOFNodeConnector((Short)port, (Node)node);
        ArrayList<String> portList = new ArrayList<String>(1);
        portList.add(nc.toString());
        ci.println((Object)this.addRemoveContainerEntries(containerName, portList, true));
    }

    private ContainerFlowConfig createSampleContainerFlowConfig(String cflowName, boolean boolUnidirectional) {
        ContainerFlowConfig cfg = new ContainerFlowConfig(cflowName, "9.9.1.0/24", "19.9.1.2", "TCP", "1234", "25");
        return cfg;
    }

    public void _addContainerFlow(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String cflowName = ci.nextArgument();
        if (cflowName == null) {
            ci.print((Object)"cflowName not specified");
            return;
        }
        String unidirectional = ci.nextArgument();
        boolean boolUnidirectional = Boolean.parseBoolean(unidirectional);
        ArrayList<ContainerFlowConfig> list = new ArrayList<ContainerFlowConfig>();
        list.add(this.createSampleContainerFlowConfig(cflowName, boolUnidirectional));
        ci.println((Object)this.addRemoveContainerFlow(containerName, list, false));
    }

    public void _removeContainerFlow(CommandInterpreter ci) {
        String containerName = ci.nextArgument();
        if (containerName == null) {
            ci.print((Object)"Container Name not specified");
            return;
        }
        String cflowName = ci.nextArgument();
        if (cflowName == null) {
            ci.print((Object)"cflowName not specified");
            return;
        }
        HashSet<String> set = new HashSet<String>(1);
        set.add(cflowName);
        ci.println((Object)this.removeContainerFlows(containerName, set));
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---ContainerManager Testing---\n");
        help.append("\tpsc        - Print ContainerConfigs\n");
        help.append("\tpfc        - Print FlowSpecConfigs\n");
        help.append("\tpsd        - Print ContainerData\n");
        help.append("\tpsp        - Print nodeConnectorToContainers\n");
        help.append("\tpsm        - Print nodeToContainers\n");
        help.append("\t addContainer <containerName> <staticVlan> \n");
        help.append("\t removeContainer <containerName> \n");
        help.append("\t addContainerEntry <containerName> <nodeId> <port> \n");
        help.append("\t removeContainerEntry <containerName> <nodeId> <port> \n");
        help.append("\t addContainerFlow <containerName> <cflowName> <unidirectional true/false>\n");
        help.append("\t removeContainerFlow <containerName> <cflowName> \n");
        return help.toString();
    }

    public boolean doesContainerExist(String containerName) {
        if (GlobalConstants.DEFAULT.toString().equalsIgnoreCase(containerName)) {
            return true;
        }
        return this.getContainerByName(containerName) != null;
    }

    @Override
    public ContainerData getContainerData(String containerName) {
        return this.getContainerByName(containerName);
    }

    public Status saveConfiguration() {
        return this.saveContainerConfig();
    }

    public void _containermgrGetRoles(CommandInterpreter ci) {
        ci.println((Object)"Configured roles for Container Mgr:");
        List list = this.getRoles();
        for (String role : list) {
            ci.println((Object)(role + "\t" + this.roles.get(role)));
        }
    }

    public void _containermgrGetAuthorizedGroups(CommandInterpreter ci) {
        String roleName = ci.nextArgument();
        if (roleName == null || roleName.trim().isEmpty()) {
            ci.println((Object)"Invalid argument");
            ci.println((Object)"mmGetAuthorizedGroups <role_name>");
            return;
        }
        ci.println((Object)("Resource Groups associated to role " + roleName + ":"));
        List list = this.getAuthorizedGroups(roleName);
        for (ResourceGroup group : list) {
            ci.println((Object)group.toString());
        }
    }

    public void _containermgrGetAuthorizedResources(CommandInterpreter ci) {
        String roleName = ci.nextArgument();
        if (roleName == null || roleName.trim().isEmpty()) {
            ci.println((Object)"Invalid argument");
            ci.println((Object)"mmGetAuthorizedResources <role_name>");
            return;
        }
        ci.println((Object)("Resource associated to role " + roleName + ":"));
        List list = this.getAuthorizedResources(roleName);
        for (Resource resource : list) {
            ci.println((Object)resource.toString());
        }
    }

    public void _containermgrGetResourcesForGroup(CommandInterpreter ci) {
        String groupName = ci.nextArgument();
        if (groupName == null || groupName.trim().isEmpty()) {
            ci.println((Object)"Invalid argument");
            ci.println((Object)"containermgrResourcesForGroup <group_name>");
            return;
        }
        ci.println((Object)("Group " + groupName + " contains the following resources:"));
        List resources = this.getResources(groupName);
        for (Object resource : resources) {
            ci.println((Object)resource.toString());
        }
    }

    public void _containermgrGetUserLevel(CommandInterpreter ci) {
        String userName = ci.nextArgument();
        if (userName == null || userName.trim().isEmpty()) {
            ci.println((Object)"Invalid argument");
            ci.println((Object)"containermgrGetUserLevel <user_name>");
            return;
        }
        ci.println((Object)("User " + userName + " has level: " + this.getUserLevel(userName)));
    }

    public void _containermgrGetUserResources(CommandInterpreter ci) {
        String userName = ci.nextArgument();
        if (userName == null || userName.trim().isEmpty()) {
            ci.println((Object)"Invalid argument");
            ci.println((Object)"containermgrGetUserResources <user_name>");
            return;
        }
        ci.println((Object)("User " + userName + " owns the following resources: "));
        Set resources = this.getAllResourcesforUser(userName);
        for (Resource resource : resources) {
            ci.println((Object)resource.toString());
        }
    }

    public void _saveConfig(CommandInterpreter ci) {
        Status status = new Status(StatusCode.NOSERVICE, "Configuration service not reachable");
        IConfigurationService configService = (IConfigurationService)ServiceHelper.getGlobalInstance(IConfigurationService.class, (Object)this);
        if (configService != null) {
            status = configService.saveConfigurations();
        }
        ci.println((Object)status.toString());
    }

    public List<String> getContainerNames() {
        return this.getContainerNameList();
    }

    public boolean hasNonDefaultContainer() {
        return !this.containerConfigs.keySet().isEmpty();
    }

    public boolean inContainerMode() {
        return this.containerConfigs.size() > 0;
    }
}

