/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.containermanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.containermanager.ContainerData;
import org.opendaylight.controller.containermanager.internal.IContainerInternal;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainer;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;

public class ContainerImpl
implements IContainer {
    private String containerName = null;
    private IContainerInternal iContainerInternal = null;

    public void setIContainerInternal(IContainerInternal s) {
        this.iContainerInternal = s;
    }

    public void unsetIContainerInternal(IContainerInternal s) {
        if (this.iContainerInternal == s) {
            this.iContainerInternal = null;
        }
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
        }
    }

    public String getName() {
        return this.containerName;
    }

    public List<ContainerFlow> getContainerFlows() {
        ArrayList<ContainerFlow> list = new ArrayList<ContainerFlow>();
        ContainerData d = this.iContainerInternal.getContainerData(this.containerName);
        if (d != null) {
            list.addAll(d.getContainerFlowSpecs());
        }
        return list;
    }

    public short getTag(Node n) {
        ContainerData d = this.iContainerInternal.getContainerData(this.containerName);
        if (d != null) {
            return d.getStaticVlan();
        }
        return 0;
    }

    public Set<NodeConnector> getNodeConnectors() {
        ConcurrentMap m;
        HashSet<NodeConnector> set = new HashSet<NodeConnector>();
        ContainerData d = this.iContainerInternal.getContainerData(this.containerName);
        if (d != null && (m = d.getSwPorts()) != null) {
            for (Map.Entry entry : m.entrySet()) {
                set.addAll((Collection)entry.getValue());
            }
        }
        return set;
    }

    public Set<Node> getNodes() {
        ConcurrentMap m;
        HashSet<Node> set = new HashSet<Node>();
        ContainerData d = this.iContainerInternal.getContainerData(this.containerName);
        if (d != null && (m = d.getSwPorts()) != null) {
            set.addAll(m.keySet());
        }
        return set;
    }

    public String getContainerAdminRole() {
        return this.iContainerInternal.getContainerData(this.containerName).getContainerAdminRole();
    }

    public String getContainerOperatorRole() {
        return this.iContainerInternal.getContainerData(this.containerName).getContainerOperatorRole();
    }
}

