/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node.OriginalNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class OriginalNodeBuilder {
    private NodeId _node;
    private TopologyId _topology;
    private Map<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>();

    public NodeId getNode() {
        return this._node;
    }

    public TopologyId getTopology() {
        return this._topology;
    }

    public <E extends Augmentation<OriginalNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OriginalNodeBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public OriginalNodeBuilder setTopology(TopologyId value) {
        this._topology = value;
        return this;
    }

    public OriginalNodeBuilder addAugmentation(Class<? extends Augmentation<OriginalNode>> augmentationType, Augmentation<OriginalNode> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OriginalNode build() {
        return new OriginalNodeImpl(this);
    }

    private static final class OriginalNodeImpl
    implements OriginalNode {
        private final NodeId _node;
        private final TopologyId _topology;
        private Map<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>();

        public Class<OriginalNode> getImplementedInterface() {
            return OriginalNode.class;
        }

        private OriginalNodeImpl(OriginalNodeBuilder builder) {
            this._node = builder.getNode();
            this._topology = builder.getTopology();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopology() {
            return this._topology;
        }

        public <E extends Augmentation<OriginalNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._topology == null ? 0 : this._topology.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginalNodeImpl other = (OriginalNodeImpl)obj;
            if (this._node == null ? other._node != null : !this._node.equals((Object)other._node)) {
                return false;
            }
            if (this._topology == null ? other._topology != null : !this._topology.equals((Object)other._topology)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OriginalNode [_node=");
            builder.append(this._node);
            builder.append(", _topology=");
            builder.append(this._topology);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

