/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.NodeType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifierKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NodeIdentifierBuilder {
    private Uri _identifier;
    private Class<? extends NodeType> _type;
    private NodeIdentifierKey _key;
    private Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>();

    public Uri getIdentifier() {
        return this._identifier;
    }

    public Class<? extends NodeType> getType() {
        return this._type;
    }

    public NodeIdentifierKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<NodeIdentifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeIdentifierBuilder setIdentifier(Uri value) {
        this._identifier = value;
        return this;
    }

    public NodeIdentifierBuilder setType(Class<? extends NodeType> value) {
        this._type = value;
        return this;
    }

    public NodeIdentifierBuilder setKey(NodeIdentifierKey value) {
        this._key = value;
        return this;
    }

    public NodeIdentifierBuilder addAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType, Augmentation<NodeIdentifier> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeIdentifier build() {
        return new NodeIdentifierImpl(this);
    }

    private static final class NodeIdentifierImpl
    implements NodeIdentifier {
        private final Uri _identifier;
        private final Class<? extends NodeType> _type;
        private final NodeIdentifierKey _key;
        private Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>();

        public Class<NodeIdentifier> getImplementedInterface() {
            return NodeIdentifier.class;
        }

        private NodeIdentifierImpl(NodeIdentifierBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new NodeIdentifierKey(builder.getIdentifier(), builder.getType());
                this._identifier = builder.getIdentifier();
                this._type = builder.getType();
            } else {
                this._key = builder.getKey();
                this._identifier = this._key.getIdentifier();
                this._type = this._key.getType();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Uri getIdentifier() {
            return this._identifier;
        }

        @Override
        public Class<? extends NodeType> getType() {
            return this._type;
        }

        @Override
        public NodeIdentifierKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<NodeIdentifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._identifier == null ? 0 : this._identifier.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeIdentifierImpl other = (NodeIdentifierImpl)obj;
            if (this._identifier == null ? other._identifier != null : !this._identifier.equals((Object)other._identifier)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NodeIdentifier [_identifier=");
            builder.append(this._identifier);
            builder.append(", _type=");
            builder.append(this._type);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

