/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.store.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.config.yang.store.api.YangStoreSnapshot;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangStoreSnapshotImpl
implements YangStoreSnapshot {
    private static final Logger logger = LoggerFactory.getLogger(YangStoreSnapshotImpl.class);
    @Deprecated
    private final Map<String, Map<String, ModuleMXBeanEntry>> moduleMXBeanEntryMap;
    private final Map<Module, String> modulesToSources;
    private final Map<QName, Map<String, ModuleMXBeanEntry>> qNamesToIdentitiesToModuleMXBeanEntries;

    public YangStoreSnapshotImpl(Map<String, Map<String, ModuleMXBeanEntry>> moduleMXBeanEntryMap, Map<Module, String> modulesToSources, Map<QName, Map<String, ModuleMXBeanEntry>> qNamesToIdentitiesToModuleMXBeanEntries) {
        this.moduleMXBeanEntryMap = Collections.unmodifiableMap(moduleMXBeanEntryMap);
        this.modulesToSources = Collections.unmodifiableMap(modulesToSources);
        this.qNamesToIdentitiesToModuleMXBeanEntries = Collections.unmodifiableMap(qNamesToIdentitiesToModuleMXBeanEntries);
    }

    public static YangStoreSnapshotImpl copy(YangStoreSnapshot yangStoreSnapshot) {
        return new YangStoreSnapshotImpl(yangStoreSnapshot.getModuleMXBeanEntryMap(), yangStoreSnapshot.getModulesToSources(), yangStoreSnapshot.getQNamesToIdentitiesToModuleMXBeanEntries());
    }

    public Map<String, Map<String, ModuleMXBeanEntry>> getModuleMXBeanEntryMap() {
        return this.moduleMXBeanEntryMap;
    }

    public Map<QName, Map<String, ModuleMXBeanEntry>> getQNamesToIdentitiesToModuleMXBeanEntries() {
        return this.qNamesToIdentitiesToModuleMXBeanEntries;
    }

    public Set<Module> getModules() {
        return this.modulesToSources.keySet();
    }

    public String getModuleSource(Module module) {
        String result = this.modulesToSources.get(module);
        if (result == null) {
            logger.trace("Cannot find module {} in {}", (Object)module, this.modulesToSources);
            throw new IllegalArgumentException("Module not found in this snapshot:" + module);
        }
        return result;
    }

    public Map<Module, String> getModulesToSources() {
        return this.modulesToSources;
    }

    public int countModuleMXBeanEntries() {
        int i = 0;
        for (Map<String, ModuleMXBeanEntry> value : this.moduleMXBeanEntryMap.values()) {
            i += value.keySet().size();
        }
        return i;
    }

    public void close() {
    }
}

